/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/include/Interface.h"
#include "Behavioural/include/Entity.h"

namespace morpheo              {
namespace behavioural          {

  XML Interface::toXML (void)
  {
    XML xml ("interface");
    
    xml.balise_open_begin ("port");
    xml.  attribut        ("name"         ,_name                 );
    xml.  attribut        ("direction"   ,toString(_direction   ));
    xml.  attribut        ("localisation",toString(_localisation));
    xml.balise_open_end   ();
    xml.  text            (get_comment());

    if (_list_signal->empty()== false)
      {
	list<Signal>::iterator i     = _list_signal->begin();

	while (i != _list_signal->end())
	  {
	    xml.  insert_XML ((*i).toXML());
	    ++i;
	  }
      }

    xml.balise_close      ();
     
    return xml;
  };

#ifdef POSITION
  XML Interface::toXML_mapping (void)
  {
    if (_is_map != true)
      throw (ErrorMorpheo ("Interface \""+_name+"\" is never mapped"));

    XML xml ("interface");
    
    xml.singleton_begin ("port_map");
    xml.  attribut      ("name"     ,_name               );
    xml.  attribut      ("component",(static_cast<Entity    *>(_entity_map   ))->_name);
    xml.  attribut      ("port"     ,(static_cast<Interface *>(_interface_map))->_name);
    xml.singleton_end   ();
     
    return xml;
  };
#endif
}; // end namespace behavioural          
}; // end namespace morpheo              
