#include "window.h"

using namespace morpheo::tools::viewer::parser;
using namespace morpheo::tools::viewer::bdd;
using namespace morpheo::tools::viewer::graphics;

void Window::paintEvent( QPaintEvent * )
{
  /*draw window size*/
  setMinimumSize(600,600);
   
  int schema;
  QString t;
 
  
  if(paint){
    /*draw the main component*/
    painter.begin(this);
    painter.setPen(Qt::blue);
    painter.drawRect(MARGEX,MARGEY,MARGEX+450,MARGEY+450);
    
    Entity *e = p.getEntity();
    string s;
    s.append(e->getName());
    s.append(" : ");
    s.append(e->getType());
    painter.setPen(Qt::black);
    painter.drawText(50,10,500,60,Qt::AlignCenter,QString::fromStdString(s));
    painter.setPen(Qt::blue);

    /*draw the ports of the main component*/
    for(QList<Port>::iterator it=port_east.begin(); it!=port_east.end(); ++it){
      portX = it->get_x();
      portY = it->get_y();
      drawPort(portX + MARGEX,portY + MARGEY ,EAST,it->getDirection());

    } 
    
    for(QList<Port>::iterator it=port_west.begin(); it!=port_west.end(); ++it){
      portX = it->get_x() ;
      portY = it->get_y() ;
      drawPort(portX + MARGEX,portY + MARGEY, WEST, it->getDirection());

    }

    for(QList<Port>::iterator it=port_north.begin(); it!=port_north.end(); ++it){
      portX = it->get_x() ;
      portY = it->get_y() ;
      drawPort(portX + MARGEX ,portY+MARGEY,NORTH,it->getDirection());

    }

    for(QList<Port>::iterator it=port_south.begin(); it!=port_south.end(); ++it){
      portX = it->get_x() ;
      portY = it->get_y() ;
      drawPort(portX + MARGEX,portY+ MARGEY + 20 ,SOUTH,it->getDirection());

    }
    
    /*draw the components inside the main component*/
    if(p.getArchitecture()!=NULL){
      compo = p.getComponent();
      for(QList<Component>::iterator it=compo->begin();it!=compo->end();++it){
	Coord *co = it->get_Position();
	posX = co->get_hg_x()+MARGEX;
	posY = co->get_hg_y()+MARGEY;
	tailleX = co->get_size_x();
	tailleY = co->get_size_y();
	
	t=QString::fromStdString(it->getType()).toLower();
	BaseP tp = base->get_BasePos(t.toStdString());
	if(&tp != NULL){
	  schema=tp.getSchema();
	  switch(schema){
	  case 0://a basic element
	    painter.drawRect(posX,posY,tailleX,tailleY);
	    break;
	  case 1://a combinatoire element
	    painter.drawEllipse(posX,posY,tailleX,tailleY);
	    break;  
	  case 2://a FIFO
	    painter.drawRect(posX,posY,tailleX,tailleY);
	    painter.drawLine(posX+tailleX/4,posY+tailleY,posX+tailleX/4,posY);
	    painter.drawLine(posX+tailleX/2,posY+tailleY,posX+tailleX/2,posY);
	    painter.drawLine(posX+3*tailleX/4,posY+tailleY,posX+3*tailleX/4,posY);
	    break;
	  case 3://a register
	    painter.drawRect(posX,posY,tailleX,tailleY);
	    painter.drawLine(posX,posY+tailleY,posX+tailleX/2,posY+tailleY/2);
	    painter.drawLine(posX+tailleX,posY+tailleY,posX+tailleX/2,posY+tailleY/2);
	    break;
	  }
	}

	if (componentName){
	  QString compo_name = QString::fromStdString(it->getName());
	  painter.drawText(posX - compo_name.size()/2 , posY + tailleY/2,compo_name);
	}

	/*draw the ports of the inside components*/
	Coord *co2=new Coord( co->get_hg_x() + tailleX/2, co->get_hg_y() + tailleY/2,tailleX/2,tailleY/2);

	QList<Port> ports2=(it->getPortEast(co2));
	for (QList<Port>::iterator it2=ports2.begin();it2!=ports2.end();++it2) 
	  {
	    
	    portX =it2->get_x();
	    portY =it2->get_y();
	    drawPort(portX + MARGEX,portY+MARGEY , EAST,it2->getDirection());
	  }
	ports2=(it->getPortWest(co));
	for (QList<Port>::iterator it2=ports2.begin();it2!=ports2.end();++it2) 
	  {
	    
	    portX =it2->get_x();
	    portY =it2->get_y();
	    drawPort(portX + MARGEX ,portY+MARGEY ,WEST,it2->getDirection());
	  }
	ports2=(it->getPortNorth(co));
	for (QList<Port>::iterator it2=ports2.begin();it2!=ports2.end();++it2) 
	  {
	    
	    portX =it2->get_x();
	    portY =it2->get_y();
	    drawPort(portX + MARGEX ,portY+MARGEY,NORTH,it2->getDirection());
	    
	  }
	ports2=(it->getPortSouth(co));
	for (QList<Port>::iterator it2=ports2.begin();it2!=ports2.end();++it2) 
	  {
	    
	    portX =it2->get_x();
	    portY =it2->get_y();
	    drawPort(portX + MARGEX ,portY+MARGEY,SOUTH,it2->getDirection());

	  }
	painter.setPen(Qt::red);
        QList<PortMap> *pm=it->getPortMap();
	
	/*draw the signals*/
	for (QList<PortMap>::iterator it3=pm->begin();it3!=pm->end();++it3) 
	  {
	    Signal *s=base->getSignal(&p,it->getName(),new PortMap(*it3));
	    painter.drawLine(s->get_src_x()+MARGEX,s->get_src_y()+MARGEY,s->get_dest_x()+MARGEX,s->get_dest_y()+MARGEY);

	    if(signalName){
	      QString signal_name = QString::fromStdString(it3->getName());
	      if(s->get_src_x() > s->get_dest_x())
		painter.drawText(s->get_dest_x() + MARGEX - 40 ,s->get_dest_y() + MARGEY-10, signal_name);
	      if(s->get_src_x() < s->get_dest_x())
		painter.drawText(s->get_dest_x() + MARGEX - 40 ,s->get_dest_y() + MARGEY-10, signal_name);
	    }

	  }
	if(charg_open){
	  charg_open = false;
	  mess_charg->close();
	}
        painter.setPen(Qt::blue);
      }
    }
    painter.end();
  }
   if(mess_open){
    mess_open = false;
    mess->close();
   }
}

void Window::repaint(){
}

