#include "window.h"

using namespace std;

using namespace morpheo::tools::viewer::parser;
using namespace morpheo::tools::viewer::bdd;
using namespace morpheo::tools::viewer::graphics;

/*informations window constructor*/
void Window::winformations()
{
  winfo = new QWidget();
  informations = new QBoxLayout(QBoxLayout::TopToBottom,0);
  winfo->setWindowTitle("informations");
  winfo->setFixedSize(370,180);
  winfo->move(628,50);
  

  /*name line*/
  QBoxLayout *bname = new QBoxLayout(QBoxLayout::LeftToRight,0);
  ln = new QLabel();
  ln->setText("");
  lname = new QLabel();
  lname->setText("");
  bname->addWidget(ln);
  bname->addWidget(lname);

  /*type line*/
  QBoxLayout *btype = new QBoxLayout(QBoxLayout::LeftToRight,0);
  lt = new QLabel();
  lt->setText("");
  ltype = new QLabel();
  ltype->setText("");
  btype->addWidget(lt);
  btype->addWidget(ltype);
  
  /*comment line*/
  comment = new QLineEdit();
  comment->setText("");
  comment->setReadOnly(true);

  /*buttons*/
  QPushButton *noselect = new QPushButton("cancel selection",wparam);
  QPushButton *back = new QPushButton("back",wparam);
  connect(back,SIGNAL(clicked()),this,SLOT(_back()));
  connect(noselect,SIGNAL(clicked()),this,SLOT(_cancel_selection()));

  informations->addLayout(bname);
  informations->addLayout(btype);
  informations->addWidget(comment);
  informations->addWidget(noselect);
  informations->addWidget(back);

  winfo->setLayout(informations);
  winfo->show();
}

/*write the comment of the componenet selected*/
void Window::write_comment(string cm){
  QString c = QString::fromStdString(cm);
  comment->setText(c);
  comment->setCursorPosition(1);
  comment->show();
}

void Window::erase_comment(){
  comment->setText("");
  comment->hide();
}
/*write the name of the component selected*/
void Window::write_name(string type,string name){
  QString n = QString::fromStdString(type);
  ln->setText(n);
  QString n2 = QString::fromStdString(name);
  lname->setText(n2);
}

void Window::erase_line(QLabel *l1, QLabel *l2){
  l1->setText("");
  l2->setText("");
}

/*write the type of the component selected*/
void Window::write_type(string type){
  lt->setText("type");
  QString n = QString::fromStdString(type);
  ltype->setText(n);
}

void Window::_cancel_selection(){
  component_clicked = false;
}
