#include "window.h"

using namespace std;
using namespace morpheo::tools::viewer::parser;
using namespace morpheo::tools::viewer::bdd;
using namespace morpheo::tools::viewer::graphics;


/*signals actions implementation*/

/*open function*/
void Window::_open(){
  QString current2;
  if(!file_open && is_save){//if no file open or if the file opened has been saved -> open other file, else -> ask for saving file
    current2 = QFileDialog::getOpenFileName(this,"", "./data");
    this->setDisabled(true);
    /*if a file has been opened*/
    if(current2!=""){
      current_name = current2;
      if(parse->open_file( current_name.toStdString(),0)==-1)
	_open_error();
      else{
	paint = false;
	repaint();
	_init_file();
      }
    }
  }
  else{
    file_open = false;
    if(!is_save){
      wa_open = true;
      wa = new QWidget();
      QBoxLayout *other_box = new QBoxLayout(QBoxLayout::LeftToRight,0);
      wa->setFixedSize(500,60);
      wa->move(50,100);
      QLabel *label = new QLabel("do you want to save this file?");
      QPushButton *yes_save = new QPushButton("yes",wa);
      QPushButton *no_save = new QPushButton("no",wa);
      if(current_name!=NULL)
	connect(yes_save,SIGNAL(clicked()),this,SLOT(_save()));
      else 
	connect(yes_save,SIGNAL(clicked()),this,SLOT(_saveAs()));
      connect(no_save,SIGNAL(clicked()),this,SLOT(_open()));
      other_box->addWidget(label);
      other_box->addWidget(yes_save);
      other_box->addWidget(no_save);
      wa->setLayout(other_box);
      wa->show();
    }
    else{
      parse->closeBaseV();
      _open();
    }
  }
}

/*initialize the database when a file has been opened*/
void Window::_init_file(){
  is_save = true;
  base = parse->getBaseV();//parse the base and open the file
  //#ifdef DEBUG_ALL
  base->afficheBaseConsole();
  //#endif
  cpt_level = 0;
  
  tab[cpt_level] = "";
  file_open = true;
  QList <BaseP> *liste_compo = base->getBaseP();
  p = liste_compo->at(0);
  entity = p.getEntity();
  current = QString::fromStdString(entity->getName());
  c = new Coord(250,250,250,250);
  port_east = entity->getPortEast(c);
  port_west = entity->getPortWest(c);
  port_north = entity->getPortNorth(c);
  port_south = entity->getPortSouth(c);
  paint = true;
  repaint();
  display_param();
  this->setDisabled(false);
  setMouseTracking(true);
}

/*if user entered a wrong file name*/
void Window::_open_error(){
  QMessageBox *error = new QMessageBox(this);
  error->setText("error : file doesn't exist or is not a valid format");
  error->addButton("ok",QMessageBox::YesRole);
  error->show();  
  this->setDisabled(false);
}  

/*save functions*/
void Window::_save(){
  if(file_open){
    if (wa_open)
      wa->close();
    if(save_as){//if "save as" 
      current_name = QFileDialog::getSaveFileName(this,"","./data");
      save_as = false;
      parse->save_file(current_name.toStdString(),0);
    }
    else {
      parse->save_file(current.toStdString(),0);
      status->showMessage("file " + current + " saved",900);
      is_save = true;//file saved
    }
    if(wa_open){
      wa_open = false;
      _open();
    }
  }
  else{
    QMessageBox *mess = new QMessageBox(this);
    mess->setText("no file opened");
    mess->addButton("ok",QMessageBox::YesRole);
    mess->show(); 
  }
}

void Window::_saveAs(){
  if (wq_open){//if "quit" window is open, close it
    wq->close();
    wq_open = false;
  }
  save_as = true;
  _save();
}

void Window::_saveAsOk(){
  is_save = true;
  status->showMessage("file " + current_name + " saved",900);
  if(wa_open){
    wa_open = false;
    _open();
  }
  if(quit_demand)//if the user clicked on "quit" (but saved the file just before) -> quit the application
    _quit2();
}

/*close function*/
void Window::_close(){
  paint = false;
  repaint();
  parse->closeBaseV();
  erase_line(ln,lname);
  erase_line(lt,ltype);
  erase_comment();
  winfo->show();
  wscroll->hide();
  scroll_hide = true;
  wparam->show();
  file_open = false;
}

/*quit functions*/
void Window::_quit(){
  //if the file is not saved -> ask to the user if he wants to save it. If yes -> save, else quit.
  if(file_open && !is_save){
    wq_open = true;
    quit_demand = true;
    wq = new QWidget();
    QBoxLayout *quit_box = new QBoxLayout(QBoxLayout::LeftToRight,0);
    wq->setWindowTitle("save : file name");
    wq->setFixedSize(500,60);
    wq->move(50,100);
    QLabel *label = new QLabel("do you want to save this file?");
    QPushButton *yes_save = new QPushButton("yes",wq);
    QPushButton *no_save = new QPushButton("no",wq);
    connect(yes_save,SIGNAL(clicked()),this,SLOT(_saveAs()));
    connect(no_save,SIGNAL(clicked()),this,SLOT(_quit2()));
    quit_box->addWidget(label);
    quit_box->addWidget(yes_save);
    quit_box->addWidget(no_save);
    wq->setLayout(quit_box);
    wq->show();
  }
  else
    _quit2();
}
/*close all the windows opened*/
void Window::_quit2(){
  /*test if there are windows (other than the main window) opened*/

  if(wq_open)
    wq->close();
  if(wa_open)
    wa->close();
  if(param_open)
    wparam->close();
  if(info_open)
    winfo->close();
  close();
}




