/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/include/Signal.h"

namespace morpheo              {
namespace behavioural          {

  Signal::Signal  (string          name         ,
		   direction_t     direction    ,
		   uint32_t        size         ,
		   presence_port_t presence_port):
    _name          (name         ),
    _direction     (direction    ),
    _size          (size         ),
    _presence_port (presence_port)
  {
    log_printf(FUNC,Behavioural,"Signal","Begin");
#ifdef VHDL_TESTBENCH
    _signal    = NULL;
    _type_info = UNKNOW;
#endif
    log_printf(FUNC,Behavioural,"Signal","End");
  };

  Signal::Signal  (const Signal & signal):
    _name          (signal._name         ),
    _direction     (signal._direction    ),
    _size          (signal._size         ),
    _presence_port (signal._presence_port)
  {
    log_printf(FUNC,Behavioural,"Signal (copy)","Begin");
#ifdef VHDL_TESTBENCH
    _signal    = signal._signal   ;
    _type_info = signal._type_info;
#endif
    log_printf(FUNC,Behavioural,"Signal (copy)","End");
  };

  Signal::~Signal ()
  {
    log_printf(FUNC,Behavioural,"~Signal","Begin");
    log_printf(FUNC,Behavioural,"~Signal","End");
  };

}; // end namespace behavioural          
}; // end namespace morpheo              
