#ifndef morpheo_behavioural_Signal_h
#define morpheo_behavioural_Signal_h

/*
 * $Id$
 *
 * [Description ]
 * 
 */

#ifdef SYSTEMC
#include "systemc.h"
#endif

#include <stdint.h>
#include <iostream>

#ifdef VHDL_TESTBENCH
#include "Behavioural/include/Vhdl_Testbench.h"
#endif

#include "Behavioural/include/Direction.h"
#include "Behavioural/include/XML.h"
#include "Include/ErrorMorpheo.h"
#include "Include/ToString.h"
#include "Include/Debug.h"

using namespace std;

namespace morpheo              {
namespace behavioural          {

  typedef enum {UNKNOW                     ,
		BOOL                       ,
		UINT8_T                    ,
		UINT16_T                   ,
		UINT32_T                   ,
		UINT64_T                   } type_info_t;

  typedef enum {PORT_VHDL_YES_TESTBENCH_YES,
		PORT_VHDL_YES_TESTBENCH_NO ,
		PORT_VHDL_NO_TESTBENCH_YES ,
		PORT_VHDL_NO_TESTBENCH_NO  } presence_port_t;

  class Signal
  {
    friend class Interface;

    // -----[fields ]----------------------------------------------------
  private   : const string          _name         ;
  private   : const direction_t     _direction    ;
  private   : const uint32_t        _size         ;
  private   : const presence_port_t _presence_port;

#ifdef VHDL_TESTBENCH
  private   : void *                _signal       ;
  private   : type_info_t           _type_info    ;
#endif

    // -----[methods ]---------------------------------------------------
  public    :                   Signal          (string          name          ,
						 direction_t     direction     ,
						 uint32_t        size          ,
						 presence_port_t presence_port = PORT_VHDL_YES_TESTBENCH_YES);
  public    :                   Signal          (const Signal &);
  public    :                   ~Signal         ();

#ifdef VHDL_TESTBENCH
  public    : void              testbench       (Vhdl_Testbench * & vhdl_testbench);

  public    : template <typename T>
              void              alloc           (void * port)
    {
      if (_type_info != UNKNOW)
	throw (ErrorMorpheo ("Signal \""+_name+"\" : already allocate."));

      _signal    = port;

      if (typeid(T) == typeid(bool    ))
	_type_info = BOOL;
      else
      if (typeid(T) == typeid(uint8_t ))
	_type_info = UINT8_T;
      else
      if (typeid(T) == typeid(uint16_t))
	_type_info = UINT16_T;
      else
      if (typeid(T) == typeid(uint32_t))
	_type_info = UINT32_T;
      else
      if (typeid(T) == typeid(uint64_t))
	_type_info = UINT64_T;
      else
	_type_info = UNKNOW;
    }
#endif

  public    : XML               toXML           (void);

  public    : friend ostream&   operator<<      (ostream& output_stream,
						 morpheo::behavioural::Signal & x);

  };
}; // end namespace behavioural          

  template<>           inline std::string toString<morpheo::behavioural::presence_port_t>(const morpheo::behavioural::presence_port_t& x)
  {
    switch (x)
      {
      case morpheo::behavioural::PORT_VHDL_YES_TESTBENCH_YES : return "Port is in VHDL's model and TestBench's model" ; break;
      case morpheo::behavioural::PORT_VHDL_YES_TESTBENCH_NO  : return "Port is in VHDL's model                      " ; break;
      case morpheo::behavioural::PORT_VHDL_NO_TESTBENCH_YES  : return "Port is in                  TestBench's model" ; break;
      case morpheo::behavioural::PORT_VHDL_NO_TESTBENCH_NO   : return "Port is in none model                        " ; break;
      default                                                : return "";                                               break;
      }
  }

}; // end namespace morpheo              

#endif
