/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Include/ChangeCase.h"
#include "Behavioural/include/Interface.h"

namespace morpheo              {
namespace behavioural          {

  Signal * Interface::set_signal (string          name     ,
				  direction_t     direction,
				  uint32_t        size     ,
				  presence_port_t presence_port)
  {
    log_printf(FUNC,Behavioural,"set_signal","Begin");
    string str_direction =  toString(direction);
    string str_interface = _name;
    string str_signal    =  name;

    LowerCase(str_direction);    
    UpperCase(str_interface);
    UpperCase(str_signal   );
    
    string signame = str_direction;
    if (_name != "")
      signame += "_"+str_interface;
    if (name  != "")
      signame += "_"+str_signal;

    Signal * sig = new Signal (signame      ,
			       direction    ,
			       size         ,
			       presence_port);

    _list_signal->push_back (sig);

    log_printf(FUNC,Behavioural,"set_signal","End");

    return sig;
  };

}; // end namespace behavioural          
}; // end namespace morpheo              
