#ifdef VHDL
/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/include/Interface.h"


namespace morpheo              {
namespace behavioural          {

  void Interface::set_port (Vhdl * & vhdl)
  {
    log_printf(FUNC,Behavioural,"set_port (Vhdl)","Begin");
    if (not _list_signal->empty())
      {
	list<Signal*>::iterator i     = _list_signal->begin();
	
	while (i != _list_signal->end())
	  {
	    presence_port_t p = (*i)->_presence_port;
	    if ((p == PORT_VHDL_YES_TESTBENCH_YES) or
		(p == PORT_VHDL_YES_TESTBENCH_NO ) )
	      vhdl->set_port ((*i)->_name,(*i)->_direction,(*i)->_size);
	    ++i;
	  }
      }
    log_printf(FUNC,Behavioural,"set_port (Vhdl)","End");
  };

  void Interface::set_port (Vhdl_Testbench * & vhdl_testbench)
  {
    log_printf(FUNC,Behavioural,"set_port (Testbench)","Begin");
    if (not _list_signal->empty())
      {
	list<Signal*>::iterator i     = _list_signal->begin();
	
	while (i != _list_signal->end())
	  {
	    presence_port_t p = (*i)->_presence_port;
	    if ((p == PORT_VHDL_YES_TESTBENCH_YES) or
		(p == PORT_VHDL_NO_TESTBENCH_YES ) )
	      vhdl_testbench->set_port ((*i)->_name,(*i)->_direction,(*i)->_size);
	    ++i;
	  }
      }
    log_printf(FUNC,Behavioural,"set_port (Testbench)","End");
  };

}; // end namespace behavioural          
}; // end namespace morpheo              
#endif
