#ifdef VHDL_TESTBENCH
/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/include/Signal.h"

namespace morpheo              {
namespace behavioural          {

  //  optimis -> pointeur de fonction afin d'viter le test et le switch
  void Signal::testbench (Vhdl_Testbench * & vhdl_testbench)
  {
    log_printf(FUNC,Behavioural,"testbench","Begin");

    if ((_presence_port == PORT_VHDL_YES_TESTBENCH_YES) or
	(_presence_port == PORT_VHDL_NO_TESTBENCH_YES))
      {
	switch (_type_info)
	  {
	  case BOOL     : 
	    {
	      switch (_direction)
		{
		case IN    : {vhdl_testbench->add_input (static_cast<sc_in  <bool    > *>(_signal)->read()); break; }
		case OUT   : {vhdl_testbench->add_output(static_cast<sc_out <bool    > *>(_signal)->read()); break; }
		case INOUT : {break;}
		}
	      break;
	    }
	  case UINT8_T  :
	    {
	      switch (_direction)
		{
		case IN    : {vhdl_testbench->add_input (static_cast<sc_in  <uint8_t > *>(_signal)->read()); break; }
		case OUT   : {vhdl_testbench->add_output(static_cast<sc_out <uint8_t > *>(_signal)->read()); break; }
		case INOUT : {break;}
		}
	      break;
	    }
	  case UINT16_T :
	    {
	      switch (_direction)
		{
		case IN    : {vhdl_testbench->add_input (static_cast<sc_in  <uint16_t> *>(_signal)->read()); break; }
		case OUT   : {vhdl_testbench->add_output(static_cast<sc_out <uint16_t> *>(_signal)->read()); break; }
		case INOUT : {break;}
		}
	      break;
	    }
	  case UINT32_T :
	    {
	      switch (_direction)
		{
		case IN    : {vhdl_testbench->add_input (static_cast<sc_in  <uint32_t> *>(_signal)->read()); break; }
		case OUT   : {vhdl_testbench->add_output(static_cast<sc_out <uint32_t> *>(_signal)->read()); break; }
		case INOUT : {break;}
		}
	      break;
	    }
	  case UINT64_T :
	    {
	      switch (_direction)
		{
		case IN    : {vhdl_testbench->add_input (static_cast<sc_in  <uint64_t> *>(_signal)->read()); break; }
		case OUT   : {vhdl_testbench->add_output(static_cast<sc_out <uint64_t> *>(_signal)->read()); break; }
		case INOUT : {break;}
		}
	      break;
	    }
	  default       :
	    throw (ErrorMorpheo ("Signal \""+_name+"\" : type unknow."));
	  }

      }

    log_printf(FUNC,Behavioural,"testbench","End");
  };

}; // end namespace behavioural          
}; // end namespace morpheo              
#endif
