#ifdef VHDL
/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Stage_1_Ifetch/Predictor/Meta_Predictor/Two_Level_Branch_Predictor/include/Two_Level_Branch_Predictor.h"

namespace morpheo {
namespace behavioural {
namespace stage_1_ifetch {
namespace predictor {
namespace meta_predictor {
namespace two_level_branch_predictor {


  void Two_Level_Branch_Predictor::vhdl_declaration (Vhdl & vhdl)
  {
    log_printf(FUNC,Two_Level_Branch_Predictor,"vhdl_declaration","Begin");

    for (uint32_t i=0; i<_param._nb_prediction; i++)
      {
	if (_param._have_bht)
	  {
	vhdl.set_signal  ("signal_PREDICT_BHT_ACK_"+toString(i), 1);
	vhdl.set_signal  ("signal_PREDICT_BHT_ADDRESS_"+toString(i), _param._bht_size_address);
	vhdl.set_signal  ("signal_PREDICT_BHT_HISTORY_"+toString(i), _param._bht_size_shifter);
	  }
	if (_param._have_pht)
	  {
	vhdl.set_signal  ("signal_PREDICT_PHT_ACK_"+toString(i), 1);
	vhdl.set_signal  ("signal_PREDICT_PHT_ADDRESS_"+toString(i), _param._pht_size_address);
	  }
      }

    for (uint32_t i=0; i<_param._nb_branch_complete; i++)
      {
	if (_param._have_bht)
	  {
	vhdl.set_signal  ("signal_BRANCH_COMPLETE_BHT_ACK_"+toString(i), 1);
	vhdl.set_signal  ("signal_BRANCH_COMPLETE_BHT_ADDRESS_"+toString(i), _param._bht_size_address);
	  }
	if (_param._have_pht)
	  {
	vhdl.set_signal  ("signal_BRANCH_COMPLETE_PHT_ACK_"+toString(i), 1);
	vhdl.set_signal  ("signal_BRANCH_COMPLETE_PHT_ADDRESS_"+toString(i), _param._pht_size_address);
	  }
      }
    log_printf(FUNC,Two_Level_Branch_Predictor,"vhdl_declaration","End");
  };

}; // end namespace two_level_branch_predictor
}; // end namespace meta_predictor
}; // end namespace predictor
}; // end namespace stage_1_ifetch

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
