#ifdef VHDL
/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Stage_1_Ifetch/Predictor/Meta_Predictor/Meta_Predictor_Glue/include/Meta_Predictor_Glue.h"

namespace morpheo {
namespace behavioural {
namespace stage_1_ifetch {
namespace predictor {
namespace meta_predictor {
namespace meta_predictor_glue {


  void Meta_Predictor_Glue::vhdl_declaration (Vhdl & vhdl)
  {
    log_printf(FUNC,Meta_Predictor_Glue,"vhdl_declaration","Begin");

    for (uint32_t i=0; i<_param._nb_prediction; i++)
      {
	if (_param._have_meta_predictor)
	  {
	if (_param._predictor_0_have_pht)
	  vhdl.set_alias ("predictor_0_direction_"+toString(i),std_logic(1), "in_PREDICT_PREDICTOR_0_PHT_HISTORY_"+toString(i),std_logic_range(_param._predictor_0_pht_size_counter-1,_param._predictor_0_pht_size_counter-1));
	else
	  vhdl.set_alias ("predictor_0_direction_"+toString(i),std_logic(1), "in_PREDICT_PREDICTOR_0_BHT_HISTORY_"+toString(i),std_logic_range(_param._predictor_0_bht_size_shifter-1,_param._predictor_0_bht_size_shifter-1));
	if (_param._predictor_1_have_pht)
	  vhdl.set_alias ("predictor_1_direction_"+toString(i),std_logic(1), "in_PREDICT_PREDICTOR_1_PHT_HISTORY_"+toString(i),std_logic_range(_param._predictor_1_pht_size_counter-1,_param._predictor_1_pht_size_counter-1));
	else
	  vhdl.set_alias ("predictor_1_direction_"+toString(i),std_logic(1), "in_PREDICT_PREDICTOR_1_BHT_HISTORY_"+toString(i),std_logic_range(_param._predictor_1_bht_size_shifter-1,_param._predictor_1_bht_size_shifter-1));
	  }

	if (_param._predictor_2_have_pht)
	  vhdl.set_alias ("predictor_2_direction_"+toString(i),std_logic(1), "in_PREDICT_PREDICTOR_2_PHT_HISTORY_"+toString(i),std_logic_range(_param._predictor_2_pht_size_counter-1,_param._predictor_2_pht_size_counter-1));
	else
	  vhdl.set_alias ("predictor_2_direction_"+toString(i),std_logic(1), "in_PREDICT_PREDICTOR_2_BHT_HISTORY_"+toString(i),std_logic_range(_param._predictor_2_bht_size_shifter-1,_param._predictor_2_bht_size_shifter-1));
      }
    log_printf(FUNC,Meta_Predictor_Glue,"vhdl_declaration","End");
  };

}; // end namespace meta_predictor_glue
}; // end namespace meta_predictor
}; // end namespace predictor
}; // end namespace stage_1_ifetch

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
