/*
 * $Id$
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Stage_1_Ifetch/Predictor/Meta_Predictor/Meta_Predictor_Glue/include/Parameters.h"

namespace morpheo {
namespace behavioural {
namespace stage_1_ifetch {
namespace predictor {
namespace meta_predictor {
namespace meta_predictor_glue {


  Parameters::Parameters (bool     have_meta_predictor               ,
			  bool     predictor_0_have_bht              ,
			  uint32_t predictor_0_bht_size_shifter      ,
			  bool     predictor_0_have_pht              ,
			  uint32_t predictor_0_pht_size_counter      ,
			  bool     predictor_1_have_bht              ,
			  uint32_t predictor_1_bht_size_shifter      ,
			  bool     predictor_1_have_pht              ,
			  uint32_t predictor_1_pht_size_counter      ,
			  bool     predictor_2_have_bht              ,
			  uint32_t predictor_2_bht_size_shifter      ,
			  bool     predictor_2_have_pht              ,
			  uint32_t predictor_2_pht_size_counter      ,
			  uint32_t nb_prediction                     ,
			  uint32_t nb_branch_complete                ) :
    _have_meta_predictor                (have_meta_predictor               ),
    
    _predictor_0_have_bht               ((have_meta_predictor==false)?false:predictor_0_have_bht              ),
    _predictor_0_bht_size_shifter       ((_predictor_0_have_bht==false)?0:predictor_0_bht_size_shifter      ),
    _predictor_0_have_pht               ((have_meta_predictor==false)?false:predictor_0_have_pht              ),
    _predictor_0_pht_size_counter       ((_predictor_0_have_pht==false)?0:predictor_0_pht_size_counter      ),

    _predictor_1_have_bht               ((have_meta_predictor==false)?false:predictor_1_have_bht              ),
    _predictor_1_bht_size_shifter       ((_predictor_1_have_bht==false)?0:predictor_1_bht_size_shifter      ),
    _predictor_1_have_pht               ((have_meta_predictor==false)?false:predictor_1_have_pht              ),
    _predictor_1_pht_size_counter       ((_predictor_1_have_pht==false)?0:predictor_1_pht_size_counter      ),

    _predictor_2_have_bht               (predictor_2_have_bht              ),
    _predictor_2_bht_size_shifter       ((_predictor_2_have_bht==false)?0:predictor_2_bht_size_shifter      ),
    _predictor_2_have_pht               (predictor_2_have_pht              ),
    _predictor_2_pht_size_counter       ((_predictor_2_have_pht==false)?0:predictor_2_pht_size_counter      ),

    _nb_prediction                      (nb_prediction                     ),
    _nb_branch_complete                 (nb_branch_complete                ),

    _size_history                       (_predictor_0_bht_size_shifter + _predictor_0_pht_size_counter +
					 _predictor_1_bht_size_shifter + _predictor_1_pht_size_counter +
					 _predictor_2_bht_size_shifter + _predictor_2_pht_size_counter )
  {
    log_printf(FUNC,Meta_Predictor_Glue,"Parameters","Begin");
    test();
    log_printf(FUNC,Meta_Predictor_Glue,"Parameters","End");
  };
  
  Parameters::Parameters (Parameters & param):
    _have_meta_predictor                (param._have_meta_predictor                ),

    _predictor_0_have_bht               (param._predictor_0_have_bht               ),
    _predictor_0_bht_size_shifter       (param._predictor_0_bht_size_shifter       ),
    _predictor_0_have_pht               (param._predictor_0_have_pht               ),
    _predictor_0_pht_size_counter       (param._predictor_0_pht_size_counter       ),

    _predictor_1_have_bht               (param._predictor_1_have_bht               ),
    _predictor_1_bht_size_shifter       (param._predictor_1_bht_size_shifter       ),
    _predictor_1_have_pht               (param._predictor_1_have_pht               ),
    _predictor_1_pht_size_counter       (param._predictor_1_pht_size_counter       ),

    _predictor_2_have_bht               (param._predictor_2_have_bht               ),
    _predictor_2_bht_size_shifter       (param._predictor_2_bht_size_shifter       ),
    _predictor_2_have_pht               (param._predictor_2_have_pht               ),
    _predictor_2_pht_size_counter       (param._predictor_2_pht_size_counter       ),

    _nb_prediction                      (param._nb_prediction                      ),
    _nb_branch_complete                 (param._nb_branch_complete                 ),

    _size_history                       (param._size_history                       )
  {
    log_printf(FUNC,Meta_Predictor_Glue,"Parameters","Begin");
    test();
    log_printf(FUNC,Meta_Predictor_Glue,"Parameters","End");
  };

  Parameters::~Parameters () 
  {
    log_printf(FUNC,Meta_Predictor_Glue,"~Parameters","Begin");
    log_printf(FUNC,Meta_Predictor_Glue,"~Parameters","End");
  };

}; // end namespace meta_predictor_glue
}; // end namespace meta_predictor
}; // end namespace predictor
}; // end namespace stage_1_ifetch

}; // end namespace behavioural
}; // end namespace morpheo              
