#ifdef VHDL_TESTBENCH
/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Stage_1_Ifetch/Predictor/Meta_Predictor/Meta_Predictor_Glue/include/Meta_Predictor_Glue.h"

namespace morpheo                    {
namespace behavioural {
namespace stage_1_ifetch {
namespace predictor {
namespace meta_predictor {
namespace meta_predictor_glue {


  void Meta_Predictor_Glue::vhdl_testbench_transition ()
  {
    log_printf(FUNC,Meta_Predictor_Glue,"vhdl_testbench_transition","Begin");

    // Evaluation before read the ouput signal
    sc_start(0);

    // In order with file Meta_Predictor_Glue_vhdl_testbench_port.cpp
    // Warning : if a output depend of a subcomponent, take directly the port of subcomponent
    // (because we have no control on the ordonnancer's policy)

    for (uint32_t i=0; i<_param._nb_prediction; i++)
      {
	if (_param._have_meta_predictor)
	  {
	_vhdl_testbench->add_input (PORT_READ( in_PREDICT_PREDICTOR_0_ACK [i]));
	_vhdl_testbench->add_input (PORT_READ( in_PREDICT_PREDICTOR_1_ACK [i]));
	  }
	_vhdl_testbench->add_input (PORT_READ( in_PREDICT_PREDICTOR_2_ACK [i]));
	_vhdl_testbench->add_output(PORT_READ(out_PREDICT_ACK [i]));

	if (_param._have_meta_predictor)
	  {
	if (_param._predictor_0_have_bht)
	_vhdl_testbench->add_input (PORT_READ( in_PREDICT_PREDICTOR_0_BHT_HISTORY [i]));
	if (_param._predictor_0_have_pht)
	_vhdl_testbench->add_input (PORT_READ( in_PREDICT_PREDICTOR_0_PHT_HISTORY [i]));
	if (_param._predictor_1_have_bht)
	_vhdl_testbench->add_input (PORT_READ( in_PREDICT_PREDICTOR_1_BHT_HISTORY [i]));
	if (_param._predictor_1_have_pht)
	_vhdl_testbench->add_input (PORT_READ( in_PREDICT_PREDICTOR_1_PHT_HISTORY [i]));
	  }
	if (_param._predictor_2_have_bht)
	_vhdl_testbench->add_input (PORT_READ( in_PREDICT_PREDICTOR_2_BHT_HISTORY [i]));
	if (_param._predictor_2_have_pht)
	_vhdl_testbench->add_input (PORT_READ( in_PREDICT_PREDICTOR_2_PHT_HISTORY [i]));

	_vhdl_testbench->add_output(PORT_READ(out_PREDICT_HISTORY [i]));
	_vhdl_testbench->add_output(PORT_READ(out_PREDICT_DIRECTION [i]));
      }

    for (uint32_t i=0; i<_param._nb_branch_complete; i++)
      {
	if (_param._have_meta_predictor)
	  {
	_vhdl_testbench->add_input (PORT_READ( in_BRANCH_COMPLETE_PREDICTOR_0_ACK [i]));
	_vhdl_testbench->add_input (PORT_READ( in_BRANCH_COMPLETE_PREDICTOR_1_ACK [i]));
	  }
	_vhdl_testbench->add_input (PORT_READ( in_BRANCH_COMPLETE_PREDICTOR_2_ACK [i]));
	_vhdl_testbench->add_output(PORT_READ(out_BRANCH_COMPLETE_ACK [i]));

	if (_param._have_meta_predictor)
	  {
	if (_param._predictor_0_have_bht)
	_vhdl_testbench->add_output(PORT_READ(out_BRANCH_COMPLETE_PREDICTOR_0_BHT_HISTORY [i]));
	if (_param._predictor_0_have_pht)
	_vhdl_testbench->add_output(PORT_READ(out_BRANCH_COMPLETE_PREDICTOR_0_PHT_HISTORY [i]));
	if (_param._predictor_1_have_bht)
	_vhdl_testbench->add_output(PORT_READ(out_BRANCH_COMPLETE_PREDICTOR_1_BHT_HISTORY [i]));
	if (_param._predictor_1_have_pht)
	_vhdl_testbench->add_output(PORT_READ(out_BRANCH_COMPLETE_PREDICTOR_1_PHT_HISTORY [i]));
	  }
	if (_param._predictor_2_have_bht)
	_vhdl_testbench->add_output(PORT_READ(out_BRANCH_COMPLETE_PREDICTOR_2_BHT_HISTORY [i]));
	if (_param._predictor_2_have_pht)
	_vhdl_testbench->add_output(PORT_READ(out_BRANCH_COMPLETE_PREDICTOR_2_PHT_HISTORY [i]));

	_vhdl_testbench->add_input (PORT_READ( in_BRANCH_COMPLETE_HISTORY [i]));
      }
    
    // add_test :
    //  - True  : the cycle must be compare with the output of systemC
    //  - False : no test
    _vhdl_testbench->add_test(true);

    _vhdl_testbench->new_cycle (); // always at the end

    log_printf(FUNC,Meta_Predictor_Glue,"vhdl_testbench_transition","End");
  };

}; // end namespace meta_predictor_glue
}; // end namespace meta_predictor
}; // end namespace predictor
}; // end namespace stage_1_ifetch

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
