#ifndef morpheo_behavioural_stage_1_ifetch_predictor_meta_predictor_meta_predictor_glue_Meta_Predictor_Glue_h
#define morpheo_behavioural_stage_1_ifetch_predictor_meta_predictor_meta_predictor_glue_Meta_Predictor_Glue_h

/*
 * $Id$
 *
 * [Description ]
 * 
 */

#ifdef SYSTEMC
#include "systemc.h"
#endif

#include <iostream>
#include "Include/ToString.h"
#include "Include/Debug.h"

#include "Behavioural/Stage_1_Ifetch/Predictor/Meta_Predictor/Meta_Predictor_Glue/include/Parameters.h"
#include "Behavioural/Stage_1_Ifetch/Predictor/Meta_Predictor/Meta_Predictor_Glue/include/Types.h"
#ifdef STATISTICS
#include "Behavioural/Stage_1_Ifetch/Predictor/Meta_Predictor/Meta_Predictor_Glue/include/Statistics.h"
#endif
#ifdef VHDL
#include "Behavioural/include/Vhdl.h"
#endif
#ifdef VHDL_TESTBENCH
#include "Behavioural/include/Vhdl_Testbench.h"
#endif

using namespace std;

namespace morpheo {
namespace behavioural {
namespace stage_1_ifetch {
namespace predictor {
namespace meta_predictor {
namespace meta_predictor_glue {


  class Meta_Predictor_Glue 
#if SYSTEMC
    : public sc_module
#endif
  {
    // -----[fields ]----------------------------------------------------
    // Parameters
  protected : const string     _name;

  protected : const Parameters _param;
//#ifdef STATISTICS
//  protected : const morpheo::behavioural::Parameters_Statistics _param_statistics;
//#endif

#ifdef STATISTICS
  private   : Statistics                     * _stat;
#endif

#ifdef VHDL_TESTBENCH
  private   : Vhdl_Testbench                 * _vhdl_testbench;
#endif

#ifdef SYSTEMC
    // ~~~~~[Interface ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // Interface
  public    : SC_CLOCK                      *  in_CLOCK                                  ;

    // Interface Predict
  public    : SC_IN (Tcontrol_t)           **  in_PREDICT_PREDICTOR_0_ACK                ;
  public    : SC_IN (Tcontrol_t)           **  in_PREDICT_PREDICTOR_1_ACK                ;
  public    : SC_IN (Tcontrol_t)           **  in_PREDICT_PREDICTOR_2_ACK                ;
  public    : SC_OUT(Tcontrol_t)           ** out_PREDICT_ACK                            ;

  public    : SC_IN (Tbht_history_t)       **  in_PREDICT_PREDICTOR_0_BHT_HISTORY        ;
  public    : SC_IN (Tpht_history_t)       **  in_PREDICT_PREDICTOR_0_PHT_HISTORY        ;
  public    : SC_IN (Tbht_history_t)       **  in_PREDICT_PREDICTOR_1_BHT_HISTORY        ;
  public    : SC_IN (Tpht_history_t)       **  in_PREDICT_PREDICTOR_1_PHT_HISTORY        ;
  public    : SC_IN (Tbht_history_t)       **  in_PREDICT_PREDICTOR_2_BHT_HISTORY        ;
  public    : SC_IN (Tpht_history_t)       **  in_PREDICT_PREDICTOR_2_PHT_HISTORY        ;
  public    : SC_OUT(Thistory_t)           ** out_PREDICT_HISTORY                        ;
  public    : SC_OUT(Tcontrol_t)           ** out_PREDICT_DIRECTION                      ;

    // Interface Branch_complete
  public    : SC_IN (Tcontrol_t)           **  in_BRANCH_COMPLETE_PREDICTOR_0_ACK        ;
  public    : SC_IN (Tcontrol_t)           **  in_BRANCH_COMPLETE_PREDICTOR_1_ACK        ;
  public    : SC_IN (Tcontrol_t)           **  in_BRANCH_COMPLETE_PREDICTOR_2_ACK        ;
  public    : SC_OUT(Tcontrol_t)           ** out_BRANCH_COMPLETE_ACK                    ;

  public    : SC_OUT(Tbht_history_t)       ** out_BRANCH_COMPLETE_PREDICTOR_0_BHT_HISTORY;
  public    : SC_OUT(Tpht_history_t)       ** out_BRANCH_COMPLETE_PREDICTOR_0_PHT_HISTORY;
  public    : SC_OUT(Tbht_history_t)       ** out_BRANCH_COMPLETE_PREDICTOR_1_BHT_HISTORY;
  public    : SC_OUT(Tpht_history_t)       ** out_BRANCH_COMPLETE_PREDICTOR_1_PHT_HISTORY;
  public    : SC_OUT(Tbht_history_t)       ** out_BRANCH_COMPLETE_PREDICTOR_2_BHT_HISTORY;
  public    : SC_OUT(Tpht_history_t)       ** out_BRANCH_COMPLETE_PREDICTOR_2_PHT_HISTORY;
  public    : SC_IN (Thistory_t)           **  in_BRANCH_COMPLETE_HISTORY                ;

    // ~~~~~[Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    // ~~~~~[Register ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    // ~~~~~[Internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#endif

    // -----[methods ]---------------------------------------------------

#ifdef SYSTEMC
    SC_HAS_PROCESS (Meta_Predictor_Glue);
#endif
  public  :          Meta_Predictor_Glue              (
#ifdef SYSTEMC
					      sc_module_name                              name,
#else					       
					      string                                      name,
#endif					       
#ifdef STATISTICS
					      morpheo::behavioural::Parameters_Statistics param_statistics,
#endif
					      Parameters                                  param );
					       
  public  :          Meta_Predictor_Glue              (Parameters param );
  public  :          ~Meta_Predictor_Glue             (void);
					       
#ifdef SYSTEMC				       
  private : void     allocation                (void);
  private : void     deallocation              (void);
				
#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
  public  : void     transition                       (void);
#endif
  public  : void     genMealy_predict_ack             (void);
  public  : void     genMealy_predict_history         (void);
  public  : void     genMealy_branch_complete_ack     (void);
  public  : void     genMealy_branch_complete_history (void);

#endif					       
#ifdef STATISTICS
  public  : string   statistics                (uint32_t depth);
#endif
					       
#if VHDL				       
  public  : void     vhdl                      (void);
  private : void     vhdl_port                 (Vhdl & vhdl);
  private : void     vhdl_declaration          (Vhdl & vhdl);
  private : void     vhdl_body                 (Vhdl & vhdl);
#endif					       
					       
#ifdef VHDL_TESTBENCH			       
  private : void     vhdl_testbench_port       (void);
  private : void     vhdl_testbench_transition (void);
#endif
  public  : void     vhdl_testbench_label      (string label);
  };

}; // end namespace meta_predictor_glue
}; // end namespace meta_predictor
}; // end namespace predictor
}; // end namespace stage_1_ifetch

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
