#ifdef SYSTEMC
/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Generic/Select/Select_Priority_Fixed/include/Select_Priority_Fixed.h"

namespace morpheo{
namespace behavioural {
namespace generic {
namespace select {
namespace select_priority_fixed {

  void Select_Priority_Fixed::allocation (void)
  {
    string rename;

    log_printf(FUNC,Select_Priority_Fixed,"allocation","Begin");

#ifdef POSITION
    _position   = new Position ();

    Entity * entity = _position->set_entity (_name                  ,
					     "Select_Priority_Fixed",
					     COMBINATORY            );

    _interfaces = entity->set_interfaces();
#else
    _interfaces = new Interfaces();
#endif

    // ~~~~~[Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

    Interface_fifo * interface_ = _interfaces->set_interface("", IN  ,WEST, "Generalist interface");

     in_CLOCK        = interface_->set_signal_clk              ("clock" ,1, PORT_VHDL_YES_TESTBENCH_NO);
     in_NRESET       = interface_->set_signal_in  <Tcontrol_t> ("nreset",1);
     in_VAL          = new SC_IN (Tcontrol_t)           * [_param._nb_entity];
    if (_param._encoding_one_hot)
    out_ACK          = new SC_OUT(Tcontrol_t)           * [_param._nb_entity];

    for (uint32_t i=0; i<_param._nb_entity; i++)
      {
	 in_VAL [i]    = interface_->set_signal_in  <Tcontrol_t> ("val_"+toString(i),1);
	if (_param._encoding_one_hot)
	out_ACK [i]    = interface_->set_signal_out <Tcontrol_t> ("ack_"+toString(i),1);
      }

    if (_param._encoding_compact)
      {
	out_ENTITY     = interface_->set_signal_out <Tentity_t > ("entity"    , _param._size_entity);
	out_ENTITY_ACK = interface_->set_signal_out <Tcontrol_t> ("entity_ack", 1);
      }

    // ~~~~~[Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

#ifdef POSITION
    _position->generate_file();
#endif

    log_printf(FUNC,Select_Priority_Fixed,"allocation","End");
  };

}; // end namespace select_priority_fixed
}; // end namespace select
}; // end namespace generic
}; // end namespace behavioural
}; // end namespace morpheo              
#endif
