#ifdef VHDL_TESTBENCH
/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/include/Signal.h"

namespace morpheo              {
namespace behavioural          {

  //  optimis -> pointeur de fonction afin d'viter le test et le switch
  void Signal::testbench (Vhdl_Testbench * & vhdl_testbench)
  {
    log_printf(FUNC,Behavioural,"testbench","Begin");

    if ((_presence_port == PORT_VHDL_YES_TESTBENCH_YES) or
	(_presence_port == PORT_VHDL_NO_TESTBENCH_YES))
      {
	string str;

	switch (_type_info)
	  {
	  case BOOL     : 
	    {
	      bool value = read <bool> ();

	      switch (_direction)
		{
		case IN    : {vhdl_testbench->add_input (value);
		              str =             toBase2 (value); break;}
		case OUT   : {vhdl_testbench->add_output(value); 
		              str =             toBase2 (value); break;}
		case INOUT : {break;}
		}
	      break;
	    }
	  case UINT8_T  :
	    {
	      uint8_t value = read <uint8_t> ();

	      switch (_direction)
		{
		case IN    : {vhdl_testbench->add_input (value); 
		              str =             toBase2 (value,_size); break;}
		case OUT   : {vhdl_testbench->add_output(value); 
		              str =             toBase2 (value,_size); break;}
		case INOUT : {break;}
		}
	      break;
	    }
	  case UINT16_T :
	    {
	      uint16_t value = read <uint16_t> ();

	      switch (_direction)
		{
		case IN    : {vhdl_testbench->add_input (value);
		              str =             toBase2 (value,_size); break;}
		case OUT   : {vhdl_testbench->add_output(value);
                              str =             toBase2 (value,_size); break;}
		case INOUT : {break;}		
		}
	      break;
	    }
	  case UINT32_T :
	    {
	      uint32_t value = read <uint32_t> ();

	      switch (_direction)
		{
		case IN    : {vhdl_testbench->add_input (value); 
		              str =             toBase2 (value,_size); break;}
		case OUT   : {vhdl_testbench->add_output(value); 
                              str =             toBase2 (value,_size); break;}
		case INOUT : {break;}
		}
	      break;
	    }
	  case UINT64_T :
	    {
	      uint64_t value = read <uint64_t> ();

	      switch (_direction)
		{
		case IN    : {vhdl_testbench->add_input (value); 
                              str =             toBase2 (value,_size); break;}
		case OUT   : {vhdl_testbench->add_output(value); 
                              str =             toBase2 (value,_size); break;}
		case INOUT : {break;}
		}
	      break;
	    }
	  default       :
	    throw (ErrorMorpheo ("Signal \""+_name+"\" : type unknow."));
	  }

	_list_value->push_back(str);
      }

    log_printf(FUNC,Behavioural,"testbench","End");
  };

}; // end namespace behavioural          
}; // end namespace morpheo              
#endif
