/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/@DIRECTORY/include/@COMPONENT.h"

namespace morpheo                    {
namespace behavioural {
@NAMESPACE_BEGIN

#ifdef SYSTEMC
  @COMPONENT::@COMPONENT (sc_module_name name,
#else
  @COMPONENT::@COMPONENT (string name,
#endif
#ifdef STATISTICS
			      morpheo::behavioural::Parameters_Statistics             param_statistics,
#endif
			      morpheo::behavioural::@NAMESPACE_USE::Parameters param ):
			      _name              (name)
			      ,_param            (param)
// #ifdef STATISTICS
// 			      ,_param_statistics (param_statistics)
// #endif
  {
    log_printf(FUNC,@COMPONENT,"@COMPONENT","Begin");

#ifdef SYSTEMC
    log_printf(INFO,@COMPONENT,"@COMPONENT","Allocation");

    allocation ();
#endif

#ifdef STATISTICS
    log_printf(INFO,@COMPONENT,"@COMPONENT","Allocation of statistics");

    // Allocation of statistics
    _stat = new Statistics (static_cast<string>(_name),
			    param_statistics          ,
			    param);
#endif

#ifdef VHDL_TESTBENCH
    log_printf(INFO,@COMPONENT,"@COMPONENT","Creation of a testbench");

    _vhdl_testbench = new Vhdl_Testbench (_name);
#endif

#ifdef VHDL
    // generate the vhdl
    log_printf(INFO,@COMPONENT,"@COMPONENT","Generate the vhdl");

    vhdl();
#endif

#ifdef SYSTEMC
//#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
    log_printf(INFO,@COMPONENT,"@COMPONENT","Method - transition");

    SC_METHOD (transition);
    dont_initialize ();
    sensitive_pos << *(in_CLOCK);
//#endif

#ifdef SYSTEMCASS_SPECIFIC
    // List dependency information
#endif    

#endif
    log_printf(FUNC,@COMPONENT,"@COMPONENT","End");
  };
  
  @COMPONENT::~@COMPONENT (void)
  {
    log_printf(FUNC,@COMPONENT,"~@COMPONENT","Begin");

#ifdef VHDL_TESTBENCH
    log_printf(INFO,@COMPONENT,"~@COMPONENT","Generate Testbench  file");

    // generate the test bench
    _vhdl_testbench->generate_file();
    delete _vhdl_testbench;
#endif

#ifdef STATISTICS
    log_printf(INFO,@COMPONENT,"~@COMPONENT","Generate Statistics file");

    _stat->generate_file(statistics(0));
    
    delete _stat;
#endif

#ifdef SYSTEMC
    log_printf(INFO,@COMPONENT,"~@COMPONENT","Deallocation");

    deallocation ();
#endif

    log_printf(FUNC,@COMPONENT,"~@COMPONENT","End");
  };

@NAMESPACE_END
}; // end namespace behavioural
}; // end namespace morpheo              
