/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Generic/RegisterFile/RegisterFile_Monolithic/include/RegisterFile_Monolithic.h"

namespace morpheo                    {
namespace behavioural                {
namespace generic                    {
namespace registerfile               {
namespace registerfile_monolithic    {

  RegisterFile_Monolithic::RegisterFile_Monolithic (
#ifdef SYSTEMC
						    sc_module_name name,
#else
						    string name        ,
#endif
#ifdef STATISTICS
						    morpheo::behavioural::Parameters_Statistics             param_statistics,
#endif
						    morpheo::behavioural::generic::registerfile::registerfile_monolithic::Parameters param ):
    _name   (name),
    _param (param)
  {
    log_printf(FUNC,RegisterFile_Monolithic,"RegisterFile_Monolithic","Begin");

#ifdef SYSTEMC
    log_printf(INFO,RegisterFile_Monolithic,"RegisterFile_Monolithic","Allocation");

    allocation ();
#endif

#ifdef STATISTICS
    _stat = new Statistics (static_cast<string>(_name),
			    param_statistics          ,
			    param);
#endif

#ifdef VHDL
    // generate the vhdl
    vhdl();
#endif

#ifdef SYSTEMC
    SC_METHOD (transition);
    dont_initialize ();
    sensitive_pos << *(in_CLOCK);
    
    SC_METHOD (genMealy_read);
    dont_initialize ();
    sensitive_neg << *(in_CLOCK);
    for (uint32_t i=0; i<_param._nb_port_read; i++)
      sensitive << *(in_READ_VAL     [i])
		<< *(in_READ_ADDRESS [i]);

#ifdef SYSTEMCASS_SPECIFIC
    // List dependency information
    for (uint32_t i=0; i<_param._nb_port_read; i++)
      {
	(*(out_READ_DATA [i])) (*( in_READ_VAL     [i]));
	(*(out_READ_DATA [i])) (*( in_READ_ADDRESS [i]));
      }
#endif    

    for (uint32_t i=0; i<_param._nb_port_read ; i++)
      PORT_WRITE(out_READ_ACK  [i], 1);
    for (uint32_t i=0; i<_param._nb_port_write; i++)
      PORT_WRITE(out_WRITE_ACK [i], 1);
#endif

    log_printf(FUNC,RegisterFile_Monolithic,"RegisterFile_Monolithic","End");
  };
  
  RegisterFile_Monolithic::~RegisterFile_Monolithic (void)
  {
#ifdef STATISTICS
    _stat->generate_file(statistics(0));
    delete _stat;
#endif

#ifdef SYSTEMC
    deallocation ();
#endif
  };

}; // end namespace registerfile_monolithic
}; // end namespace registerfile 
}; // end namespace generic
}; // end namespace behavioural          
}; // end namespace morpheo              
