#ifndef morpheo_behavioural_generic_registerfile_registerfile_monolithic_RegisterFile_Monolithic
#define morpheo_behavioural_generic_registerfile_registerfile_monolithic_RegisterFile_Monolithic

/*
 * $Id$
 *
 * [Description ]
 * 
 */

#ifdef SYSTEMC
#include "systemc.h"
#endif

#include "Include/Debug.h"
#include "Include/ToString.h"
#include <iostream>
using namespace std;

#include "Behavioural/Generic/RegisterFile/RegisterFile_Monolithic/include/Parameters.h"
#include "Behavioural/Generic/RegisterFile/RegisterFile_Monolithic/include/Types.h"
#ifdef STATISTICS
#include "Behavioural/Generic/RegisterFile/RegisterFile_Monolithic/include/Statistics.h"
#endif
#ifdef POSITION
#include "Behavioural/include/Position.h"
#else
#include "Behavioural/include/Interfaces.h"
#endif
#ifdef VHDL
#include "Behavioural/include/Vhdl.h"
#endif

using namespace std;

namespace morpheo                    {
namespace behavioural                {
namespace generic                    {
namespace registerfile               {
namespace registerfile_monolithic    {

  class RegisterFile_Monolithic 
#if SYSTEMC
    : public sc_module
#endif
  {
    // -----[fields ]----------------------------------------------------
    // Parameters
  protected : const string     _name;

  protected : const Parameters _param;
#ifdef STATISTICS
  private   : Statistics                     * _stat;
    
  private   : uint32_t                         _stat_nb_read;
  private   : uint32_t                         _stat_nb_write;
#endif

#ifdef POSITION
  private   : Position                       * _position;
#endif

  private   : Interfaces                     * _interfaces;

#ifdef SYSTEMC
    // ~~~~~[Interface ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // Interface
  public    : SC_CLOCK                      *  in_CLOCK        ;
  public    : SC_IN       (Tcontrol_t)      *  in_NRESET       ;

    // ----- Interface Read
  public    : SC_IN       (Tcontrol_t)     **  in_READ_VAL     ;
  public    : SC_OUT      (Tcontrol_t)     ** out_READ_ACK     ;
  public    : SC_IN       (Taddress_t)     **  in_READ_ADDRESS ;
  public    : SC_OUT      (Tdata_t)        ** out_READ_DATA    ;

    // ----- Interface Write
  public    : SC_IN       (Tcontrol_t)     **  in_WRITE_VAL    ;
  public    : SC_OUT      (Tcontrol_t)     ** out_WRITE_ACK    ;
  public    : SC_IN       (Taddress_t)     **  in_WRITE_ADDRESS;
  public    : SC_IN       (Tdata_t)        **  in_WRITE_DATA   ;

    // ~~~~~[Register ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
  private   : SC_REGISTER (Tdata_t)        ** reg_DATA         ;

    // ~~~~~[Internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#endif

    // -----[methods ]---------------------------------------------------

#ifdef SYSTEMC
    SC_HAS_PROCESS (RegisterFile_Monolithic);
#endif					       

  public  :          RegisterFile_Monolithic   (
#ifdef SYSTEMC
						sc_module_name                              name,
#else					       
						string                                      name,
#endif					       
#ifdef STATISTICS
						morpheo::behavioural::Parameters_Statistics param_statistics,
#endif
					        Parameters                                  param );
					       
  public  :          RegisterFile_Monolithic   (Parameters param );
  public  :          ~RegisterFile_Monolithic  (void);
					       
#ifdef SYSTEMC				       
  private : void     allocation                (void);
  private : void     deallocation              (void);
					       
  public  : void     transition                (void);
//public  : void     genMoore                  (void) {/* empty */};
  public  : void     genMealy_read             (void);
#endif					       

#ifdef STATISTICS
  public  : string  statistics                 (uint32_t depth);
#endif					       
#if VHDL				       
  private : void     vhdl                      (void);
  private : void     vhdl_port                 (Vhdl * & vhdl);
  private : void     vhdl_type                 (Vhdl * & vhdl);
  private : void     vhdl_signal               (Vhdl * & vhdl);
  private : void     vhdl_body                 (Vhdl * & vhdl);
#endif					       
					       
#ifdef VHDL_TESTBENCH			       
  private : void     vhdl_testbench_transition (void);
#endif

  };

}; // end namespace registerfile_monolithic
}; // end namespace registerfile 
}; // end namespace generic
}; // end namespace behavioural          
}; // end namespace morpheo              

#endif
