#ifndef morpheo_behavioural_Signal_h
#define morpheo_behavioural_Signal_h

/*
 * $Id$
 *
 * [Description ]
 * 
 */

#ifdef SYSTEMC
#include "systemc.h"
#endif

#include <stdint.h>
#include <iostream>

#ifdef VHDL
#include "Behavioural/include/Vhdl.h"
#endif

#include "Behavioural/include/Direction.h"
#include "Behavioural/include/XML.h"
#include "Include/ErrorMorpheo.h"
#include "Include/ToBase2.h"
#include "Include/ToString.h"
#include "Include/Debug.h"

using namespace std;

namespace morpheo              {
namespace behavioural          {

  typedef enum {UNKNOW                     ,
		BOOL                       ,
		UINT8_T                    ,
		UINT16_T                   ,
		UINT32_T                   ,
		UINT64_T                   } type_info_t;

  typedef enum {PORT_VHDL_YES_TESTBENCH_YES,
		PORT_VHDL_YES_TESTBENCH_NO ,
		PORT_VHDL_NO_TESTBENCH_YES ,
		PORT_VHDL_NO_TESTBENCH_NO  ,
		CLOCK_VHDL_YES             ,
		CLOCK_VHDL_NO              } presence_port_t;

  class Signal
  {
    friend class Interface;

    // -----[fields ]----------------------------------------------------
  private   : const string          _name         ;
  private   : const direction_t     _direction    ;
  private   : const uint32_t        _size         ;
  private   : const presence_port_t _presence_port;

#ifdef VHDL_TESTBENCH
  private   : void *                _signal       ;
  private   : type_info_t           _type_info    ;

  private   : list<string>        * _list_value   ;
#endif

    // -----[methods ]---------------------------------------------------
  public    :                   Signal          (string          name          ,
						 direction_t     direction     ,
						 uint32_t        size          ,
						 presence_port_t presence_port = PORT_VHDL_YES_TESTBENCH_YES);
  public    :                   Signal          (const Signal &);
  public    :                   ~Signal         ();

#ifdef VHDL_TESTBENCH
  public    :template <typename T>
             T                  read (void)
    {
      switch (_direction)
	{
	case IN  : {return read_in  <T>();}
	case OUT : {return read_out <T>();}
	default  : throw (ErrorMorpheo ("Signal \""+_name+"\" : direction unknow."));
	}
    }

  public    :template <typename T>
             T                  read_in (void)
    {
      switch (_type_info)
	{
	case BOOL     : return (static_cast<sc_in  <bool    > *>(_signal)->read()); 
	case UINT8_T  : return (static_cast<sc_in  <uint8_t > *>(_signal)->read()); 
	case UINT16_T : return (static_cast<sc_in  <uint16_t> *>(_signal)->read());
	case UINT32_T : return (static_cast<sc_in  <uint32_t> *>(_signal)->read()); 
	case UINT64_T : return (static_cast<sc_in  <uint64_t> *>(_signal)->read()); 
	default       : throw (ErrorMorpheo ("Signal \""+_name+"\" : type unknow."));
	}
    }

  public    :template <typename T>
             T                  read_out(void)
    {
      switch (_type_info)
	{
	case BOOL     : return (static_cast<sc_out <bool    > *>(_signal)->read()); 
	case UINT8_T  : return (static_cast<sc_out <uint8_t > *>(_signal)->read()); 
	case UINT16_T : return (static_cast<sc_out <uint16_t> *>(_signal)->read());
	case UINT32_T : return (static_cast<sc_out <uint32_t> *>(_signal)->read()); 
	case UINT64_T : return (static_cast<sc_out <uint64_t> *>(_signal)->read()); 
	default       : throw (ErrorMorpheo ("Signal \""+_name+"\" : type unknow."));
	}
    }

  public    : template <typename T>
              void              alloc           (void * port)
    {
      if (_type_info != UNKNOW)
	throw (ErrorMorpheo ("Signal \""+_name+"\" : already allocate."));

      _signal    = port;

      if (typeid(T) == typeid(bool    ))
	_type_info = BOOL;
      else
      if (typeid(T) == typeid(uint8_t ))
	_type_info = UINT8_T;
      else
      if (typeid(T) == typeid(uint16_t))
	_type_info = UINT16_T;
      else
      if (typeid(T) == typeid(uint32_t))
	_type_info = UINT32_T;
      else
      if (typeid(T) == typeid(uint64_t))
	_type_info = UINT64_T;
      else
	_type_info = UNKNOW;
    }

  public    : void              testbench        (void);
  public    : void              testbench_body   (Vhdl           * & vhdl          ,
						  string             counter_name  );
  public    : void              testbench_test_ok(Vhdl           * & vhdl          );
#endif
#ifdef VHDL
  public    : void              set_port        (Vhdl * & vhdl);
#  ifdef VHDL_TESTBENCH
  public    : string            get_clock       (void);
  public    : void              set_signal      (Vhdl * & vhdl);
  public    : void              get_name_vhdl   (list<string> * & list_signal);
#  endif
#endif
  public    : XML               toXML           (void);

  public    : friend ostream&   operator<<      (ostream& output_stream,
						 morpheo::behavioural::Signal & x);

  };
}; // end namespace behavioural          

  template<>           inline std::string toString<morpheo::behavioural::presence_port_t>(const morpheo::behavioural::presence_port_t& x)
  {
    switch (x)
      {
      case morpheo::behavioural::PORT_VHDL_YES_TESTBENCH_YES : return "Port is in VHDL's model and TestBench's model" ; break;
      case morpheo::behavioural::PORT_VHDL_YES_TESTBENCH_NO  : return "Port is in VHDL's model                      " ; break;
      case morpheo::behavioural::PORT_VHDL_NO_TESTBENCH_YES  : return "Port is in                  TestBench's model" ; break;
      case morpheo::behavioural::PORT_VHDL_NO_TESTBENCH_NO   : return "Port is in none model                        " ; break;
      default                                                : return "";                                               break;
      }
  }

}; // end namespace morpheo              

#endif
