/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/include/Interface.h"

namespace morpheo              {
namespace behavioural          {

  Interface::Interface  (string                name         ,
			 direction_t           direction    ,
			 localisation_t        localisation ):
    _name         (name        ),
    _direction    (direction   ),
    _localisation (localisation)
  {
    log_printf(FUNC,Behavioural,"Interface","Begin");

    _comment       = "";
    _list_signal   = new (list<Signal*>);

#ifdef POSITION
    _is_map        = false;
    _entity_map    = NULL;
    _interface_map = NULL;
#endif

#ifdef VHDL_TESTBENCH
    _nb_cycle      = 0;
#endif

    log_printf(FUNC,Behavioural,"Interface","End");
  };

  Interface::Interface  (const Interface & interface):
    _name         (interface._name        ),
    _direction    (interface._direction   ),
    _localisation (interface._localisation)
  {
    log_printf(FUNC,Behavioural,"Interface (copy)","Begin");
    _comment       = interface._comment    ;
    _list_signal   = interface._list_signal;
#ifdef POSITION
    _is_map        = interface._is_map     ;
    _entity_map    = interface._entity_map   ;
    _interface_map = interface._interface_map;
#endif
#ifdef VHDL_TESTBENCH
    _nb_cycle      = interface._nb_cycle;
#endif

    log_printf(FUNC,Behavioural,"Interface (copy)","End");
  };
  
  Interface::~Interface ()
  {
    log_printf(FUNC,Behavioural,"~Interface","Begin");

    if (_list_signal->empty()== false)
      {
	list<Signal*>::iterator i = _list_signal->begin();

	while (i != _list_signal->end())
	  {
	    delete (*i);
	    ++i;
	  }
      }

    delete _list_signal;

    log_printf(FUNC,Behavioural,"~Interface","End");
  };
  

}; // end namespace behavioural          
}; // end namespace morpheo              
