#ifdef VHDL_TESTBENCH
/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/include/Interface_fifo.h"

namespace morpheo              {
namespace behavioural          {

  string Interface_fifo::testbench_test (Vhdl * & vhdl,
				       string   counter_name)
  {
    log_printf(FUNC,Behavioural,"testbench_test","Begin");
    string test_name;
    
    if (_test_exhaustive == true)
      test_name = Interface::testbench_test(vhdl,counter_name);
    else
      {
	vhdl->set_body("");
	vhdl->set_body("-- Test partial");
	vhdl->set_body("");

	test_name    = testbench_test_name   (vhdl);
	string test_name_ok = testbench_test_ok     (vhdl);

	if (_list_cycle->empty()== false)
	  {
	    vhdl->set_body ("with "+counter_name+" select");
	    vhdl->set_body ("\t"+test_name+" <=");
	
	    list<uint32_t>::iterator i = _list_cycle->begin();
	    
	    while (i != _list_cycle->end())
	      {
		vhdl->set_body ("\t"+test_name_ok+" when "+toString(*i)+",");
		++i;
	      }
	    vhdl->set_body ("\t'1' when others;");
	  }
      }

    log_printf(FUNC,Behavioural,"testbench_test","End");

    return test_name;

  };

}; // end namespace behavioural          
}; // end namespace morpheo              
#endif
