#ifdef SYSTEMC
/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Generic/RegisterFile/RegisterFile_Monolithic/include/RegisterFile_Monolithic.h"

namespace morpheo                    {
namespace behavioural                {
namespace generic                    {
namespace registerfile               {
namespace registerfile_monolithic    {

  void RegisterFile_Monolithic::allocation (void)
  {
#ifdef POSITION
    _position   = new Position ();

    Entity * entity = _position->set_entity (_name                    ,
					     "RegisterFile_Monolithic",
					     REGISTER                 );
    
    _interfaces = entity->set_interfaces();
#else
    _interfaces = new Interfaces();
#endif

    // ~~~~~[Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    Interface * interface_ = _interfaces->set_interface("", IN  ,SOUTH, "Generalist interface");

     in_CLOCK              = interface_->set_signal_clk              ("clock" ,1);
     in_NRESET             = interface_->set_signal_in  <Tcontrol_t> ("nreset",1);

    // ~~~~~[Interface : "read" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

     in_READ_VAL         = new SC_IN (Tcontrol_t) * [_param._nb_port_read];
    out_READ_ACK         = new SC_OUT(Tcontrol_t) * [_param._nb_port_read];
     in_READ_ADDRESS     = new SC_IN (Taddress_t) * [_param._nb_port_read];
    out_READ_DATA        = new SC_OUT(Tdata_t   ) * [_param._nb_port_read];

    for (uint32_t i=0; i<_param._nb_port_read; i++)
      { 
	Interface_fifo * interface_read = _interfaces->set_interface("read_"+toString(i), IN  ,WEST, "Interface Read");

	 in_READ_VAL     [i]  = interface_read->set_signal_valack_in        ("val"    , VAL);
	out_READ_ACK     [i]  = interface_read->set_signal_valack_out       ("ack"    , ACK);
	 in_READ_ADDRESS [i]  = interface_read->set_signal_in  <Taddress_t> ("address", static_cast<uint32_t>(log2(_param._nb_word)));
	out_READ_DATA    [i]  = interface_read->set_signal_out <Tdata_t   > ("data"   , _param._size_word);
      }

    // ~~~~~[Interface : "write" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

     in_WRITE_VAL        = new SC_IN (Tcontrol_t) * [_param._nb_port_write];
    out_WRITE_ACK        = new SC_OUT(Tcontrol_t) * [_param._nb_port_write];
     in_WRITE_ADDRESS    = new SC_IN (Taddress_t) * [_param._nb_port_write];
     in_WRITE_DATA       = new SC_IN (Tdata_t   ) * [_param._nb_port_write];
    
    for (uint32_t i=0; i<_param._nb_port_write; i++)
      {
	Interface_fifo * interface_write = _interfaces->set_interface("write_"+toString(i), IN  ,EAST, "Interface Write");

	 in_WRITE_VAL     [i]  = interface_write->set_signal_valack_in        ("val"    , VAL);
	out_WRITE_ACK     [i]  = interface_write->set_signal_valack_out       ("ack"    , ACK);
	 in_WRITE_ADDRESS [i]  = interface_write->set_signal_in  <Taddress_t> ("address", static_cast<uint32_t>(log2(_param._nb_word)));
	 in_WRITE_DATA    [i]  = interface_write->set_signal_in  <Tdata_t   > ("data"   , _param._size_word);
      }

    // ----- Register
    reg_DATA = new SC_REGISTER (Tdata_t) * [_param._nb_word];
    
    for (uint32_t i=0; i<_param._nb_word; i++)
      {
	string rename = "reg_DATA["  + toString(i) + "]";
	reg_DATA [i]  = new SC_REGISTER (Tdata_t) (rename.c_str());
      }

#ifdef POSITION
    _position->generate_file();
#endif
  };

}; // end namespace registerfile_monolithic
}; // end namespace registerfile 
}; // end namespace generic
}; // end namespace behavioural          
}; // end namespace morpheo              
#endif
