/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/include/Interface_fifo.h"

namespace morpheo              {
namespace behavioural          {

  Interface_fifo::Interface_fifo  (string         name        ,
				   direction_t    direction   ,
				   localisation_t localisation):
    Interface (name        , 
	       direction   ,
	       localisation)
  {
    log_printf(FUNC,Behavioural,"Interface_fifo","Begin");

    _list_signal_val = new (list<Signal*>);
    _list_signal_ack = new (list<Signal*>);

#ifdef VHDL_TESTBENCH
    _test_exhaustive = true;
    _list_cycle      = new list<uint32_t>;
#endif

    log_printf(FUNC,Behavioural,"Interface_fifo","End");
  };

  Interface_fifo::Interface_fifo  (const Interface_fifo & interface_fifo) :
    Interface (interface_fifo._name        , 
	       interface_fifo._direction   ,
	       interface_fifo._localisation)
  {
    log_printf(FUNC,Behavioural,"Interface_fifo (copy)","Begin");

    _list_signal_val = interface_fifo._list_signal_val;
    _list_signal_ack = interface_fifo._list_signal_ack;

#ifdef VHDL_TESTBENCH
    _test_exhaustive = interface_fifo._test_exhaustive;
    _list_cycle      = interface_fifo._list_cycle;
#endif

    log_printf(FUNC,Behavioural,"Interface_fifo (copy)","End");
  };
  
  Interface_fifo::~Interface_fifo ()
  {
    log_printf(FUNC,Behavioural,"~Interface_fifo","Begin");

    delete _list_signal_val;
    delete _list_signal_ack;

#ifdef VHDL_TESTBENCH
    delete _list_cycle;
#endif

    log_printf(FUNC,Behavioural,"~Interface_fifo","End");
  };

}; // end namespace behavioural          
}; // end namespace morpheo              
