/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/include/Interface.h"


namespace morpheo              {
namespace behavioural          {

  string Interface::get_signal (void)
  {
    log_printf(FUNC,Behavioural,"get_signal","Begin");

    uint32_t               depth          = 0;
    string                 separator      = ",\n";
    bool                   last_separator = false;


    list<Signal*>::iterator i    = _list_signal->begin();
    bool                   empty = _list_signal->empty();

    string                 tab   = string(depth,'\t');
    ostringstream          text;

    if (not empty)
      {
	// First
	if (i != _list_signal->end())
	  {
	    text << tab << **i;
	    ++i;
	  }
	
	while (i != _list_signal->end())
	  {
	    text << separator;
	    text << tab << **i;
	    ++i;
	  }
	if (last_separator)
	  text << separator;
      }

    log_printf(FUNC,Behavioural,"get_signal","End");

    return text.str();
  };

#ifdef VHDL
#  ifdef VHDL_TESTBENCH
  void Interface::get_signal (list<string> * & list_signal)
  {
    if (not _list_signal->empty())
      {
	list<Signal*>::iterator i = _list_signal->begin();
	
	while (i != _list_signal->end())
	  {
	    (*i)->get_name_vhdl (list_signal);
	    ++i;
	  }
      }
  };
#  endif
#endif

}; // end namespace behavioural          
}; // end namespace morpheo              
