#ifndef morpheo_behavioural_Interfaces_h
#define morpheo_behavioural_Interfaces_h

/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include <stdint.h>
#include <iostream>
#include <list>
#include "Behavioural/include/Interface_fifo.h"
#include "Include/ToString.h"
#include "Include/Debug.h"
#ifdef VHDL
#include "Behavioural/include/Vhdl.h"
#endif

using namespace std;

namespace morpheo              {
namespace behavioural          {

  class Interfaces
  {
    // -----[fields ]----------------------------------------------------
  private   : const string               _name;
  private   : list<Interface_fifo*>    * _list_interface;

    // -----[methods ]---------------------------------------------------
  public    :                       Interfaces            (string name);
  public    :                       Interfaces            (const Interfaces & interfaces);
  public    :                       ~Interfaces           ();

  public    : Interface_fifo *      set_interface         (string         name        
#ifdef POSITION
							   ,direction_t    direction   
							   ,localisation_t localisation
#endif
							   );
#ifdef POSITION
  public    : Interface_fifo *      set_interface         (string         name        ,
							   direction_t    direction   ,
							   localisation_t localisation,
							   string         comment     );
#endif
  private   : string                get_interface         (void);
  public    :list<Interface_fifo*>* get_interface_list    (void);

#ifdef VHDL
  public    : void                  set_port              (Vhdl           * & vhdl          );
#  ifdef VHDL_TESTBENCH
  private   : void                  get_signal            (list<string>   * & list_signal   );
  private   : void                  set_signal            (Vhdl           * & vhdl          );
#  endif
#endif
#ifdef VHDL_TESTBENCH
  private   : uint32_t              get_cycle             (void);
  private   : Signal *              get_clock             (void);
  private   : Signal *              get_reset             (void);

  private   : void                  testbench_generate_file (void);
  public    : void                  testbench             (void);
  private   : string                testbench_body        (Vhdl           * & vhdl          ,
							   string             counter_name  ,
							   string             reset_name    );
#endif

  public    : Interface_fifo  *     find_interface        (string name);
  public    : Signal          *     find_signal           (string name);
  public    : bool                  find_signal           (Signal * signal);

#ifdef POSITION
  public    : XML                   toXML                 (void);
  public    : XML                   toXML_mapping         (void);
#endif
  public    : friend ostream&       operator<<            (ostream& output_stream,
  					  		   morpheo::behavioural::Interfaces & x);

  };

}; // end namespace behavioural          
}; // end namespace morpheo              

#endif
