#ifndef morpheo_behavioural_Entity_h
#define morpheo_behavioural_Entity_h

/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include <stdint.h>
#include <iostream>
#include <list>
//#include "Behavioural/include/Description.h"
#include "Behavioural/include/Interfaces.h"
#include "Behavioural/include/Schema.h"
#include "Include/ErrorMorpheo.h"
#include "Include/ToString.h"
#include "Include/Debug.h"

using namespace std;

namespace morpheo              {
namespace behavioural          {

  class Entity
  {
    // -----[fields ]----------------------------------------------------
  private   : const string          _name         ;
  private   : const string          _type         ;
#ifdef POSITION
  private   : const schema_t        _schema       ;
#endif
  private   : Interfaces          * _interfaces   ;

#ifdef POSITION
  private   : string                _comment      ;

  private   :       bool            _is_map       ;
  private   :       uint32_t        _map_size_x   ;
  private   :       uint32_t        _map_size_y   ;
  private   :       uint32_t        _map_pos_x    ;
  private   :       uint32_t        _map_pos_y    ;
#endif

    // -----[methods ]---------------------------------------------------
  public    :                       Entity            ( string        name   
						       ,string        type   
#ifdef POSITION
						       ,schema_t      schema 
#endif
							);
  public    :                        Entity           (const Entity & entity);
  public    :                       ~Entity           ();

  public    : string                get_name          (void);
  public    : string                get_type          (void);

#ifdef POSITION
  public    : void                  set_comment       (string comment);
  private   : string                get_comment       (void          );
#endif
  public    : Interfaces *          set_interfaces    (void);
  private   : string                get_interfaces    (void);
  public    : Interfaces *          get_interfaces_list(void);

  public    : Interface  *          find_interface    (string name);
  public    : Signal     *          find_signal       (string name);
  public    : bool                  find_signal       (Signal * signal);

#ifdef POSITION
  public    : void                  mapping           (uint32_t pos_x,
						       uint32_t pos_y,
						       uint32_t size_x ,
						       uint32_t size_y );
#endif

#ifdef POSITION
  public    : XML                   toXML             (void);
  public    : XML                   toXML_mapping     (void);
#endif
  public    : friend ostream&       operator<<        (ostream& output_stream,
  					  	       morpheo::behavioural::Entity & x);
  };

}; // end namespace behavioural          
}; // end namespace morpheo              

#endif
