/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/include/Signal.h"


namespace morpheo              {
namespace behavioural          {

  void Signal::link (Signal * signal)
  {
    if (        _is_allocate == false)
      throw (ErrorMorpheo ("Signal \""+_name+"\", can't map with signal \""+        get_name()+"\", because it's not already allocate."));
    if (signal->_is_allocate == false)
      throw (ErrorMorpheo ("Signal \""+_name+"\", can't map with signal \""+signal->get_name()+"\", because it's not already allocate."));
    
    _signal = signal;

    if ((_direction == IN ) and (signal->_direction == IN ))
      switch (_type_info)
	{
	case BOOL     : {(*(static_cast<sc_in  <bool    > *>(_sc_signal))) (*(static_cast<sc_in  <bool    > *>(signal->_sc_signal))); break;}
	case UINT8_T  : {(*(static_cast<sc_in  <uint8_t > *>(_sc_signal))) (*(static_cast<sc_in  <uint8_t > *>(signal->_sc_signal))); break;}
	case UINT16_T : {(*(static_cast<sc_in  <uint16_t> *>(_sc_signal))) (*(static_cast<sc_in  <uint16_t> *>(signal->_sc_signal))); break;}
	case UINT32_T : {(*(static_cast<sc_in  <uint32_t> *>(_sc_signal))) (*(static_cast<sc_in  <uint32_t> *>(signal->_sc_signal))); break;}
	case UINT64_T : {(*(static_cast<sc_in  <uint64_t> *>(_sc_signal))) (*(static_cast<sc_in  <uint64_t> *>(signal->_sc_signal))); break;}
	default       : {throw (ErrorMorpheo ("Signal \""+_name+"\" : type unknow.")); break;}
	}
    else
      if ((_direction == OUT) and (signal->_direction == OUT))
	switch (_type_info)
	  {
	  case BOOL     : {(*(static_cast<sc_out <bool    > *>(_sc_signal))) (*(static_cast<sc_out <bool    > *>(signal->_sc_signal))); break;} 
	  case UINT8_T  : {(*(static_cast<sc_out <uint8_t > *>(_sc_signal))) (*(static_cast<sc_out <uint8_t > *>(signal->_sc_signal))); break;} 
	  case UINT16_T : {(*(static_cast<sc_out <uint16_t> *>(_sc_signal))) (*(static_cast<sc_out <uint16_t> *>(signal->_sc_signal))); break;}
	  case UINT32_T : {(*(static_cast<sc_out <uint32_t> *>(_sc_signal))) (*(static_cast<sc_out <uint32_t> *>(signal->_sc_signal))); break;} 
	  case UINT64_T : {(*(static_cast<sc_out <uint64_t> *>(_sc_signal))) (*(static_cast<sc_out <uint64_t> *>(signal->_sc_signal))); break;} 
	  default       : {throw (ErrorMorpheo ("Signal \""+_name+"\" : type unknow.")); break;}
	  }
      else
	if ((_direction == IN ) and (signal->_direction == OUT))
	  switch (_type_info)
	    {
	    case BOOL     : {(*(static_cast<sc_in  <bool    > *>(_sc_signal))) (*(static_cast<sc_out <bool    > *>(signal->_sc_signal))); break;}
	    case UINT8_T  : {(*(static_cast<sc_in  <uint8_t > *>(_sc_signal))) (*(static_cast<sc_out <uint8_t > *>(signal->_sc_signal))); break;}
	    case UINT16_T : {(*(static_cast<sc_in  <uint16_t> *>(_sc_signal))) (*(static_cast<sc_out <uint16_t> *>(signal->_sc_signal))); break;}
	    case UINT32_T : {(*(static_cast<sc_in  <uint32_t> *>(_sc_signal))) (*(static_cast<sc_out <uint32_t> *>(signal->_sc_signal))); break;}
	    case UINT64_T : {(*(static_cast<sc_in  <uint64_t> *>(_sc_signal))) (*(static_cast<sc_out <uint64_t> *>(signal->_sc_signal))); break;}
	    default       : {throw (ErrorMorpheo ("Signal \""+_name+"\" : type unknow.")); break;}
	    }
	else
	  if ((_direction == OUT) and (signal->_direction == IN ))
	    switch (_type_info)
	      {
	      case BOOL     : {(*(static_cast<sc_out <bool    > *>(_sc_signal))) (*(static_cast<sc_in  <bool    > *>(signal->_sc_signal))); break;}
	      case UINT8_T  : {(*(static_cast<sc_out <uint8_t > *>(_sc_signal))) (*(static_cast<sc_in  <uint8_t > *>(signal->_sc_signal))); break;}
	      case UINT16_T : {(*(static_cast<sc_out <uint16_t> *>(_sc_signal))) (*(static_cast<sc_in  <uint16_t> *>(signal->_sc_signal))); break;}
	      case UINT32_T : {(*(static_cast<sc_out <uint32_t> *>(_sc_signal))) (*(static_cast<sc_in  <uint32_t> *>(signal->_sc_signal))); break;}
	      case UINT64_T : {(*(static_cast<sc_out <uint64_t> *>(_sc_signal))) (*(static_cast<sc_in  <uint64_t> *>(signal->_sc_signal))); break;}
	      default       : {throw (ErrorMorpheo ("Signal \""+_name+"\" : type unknow.")); break;}
	      }
	  else
	    throw (ErrorMorpheo ("Signal \""+_name+"\" : unsupported direction to link."));
  };

}; // end namespace behavioural          
}; // end namespace morpheo              
