#ifdef SYSTEMC
/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Generic/Victim/Victim_Pseudo_LRU/include/Victim_Pseudo_LRU.h"

namespace morpheo {
namespace behavioural {
namespace generic {
namespace victim {
namespace victim_pseudo_lru {

  void Victim_Pseudo_LRU::transition (void)
  {
#ifdef STATISTICS
    uint32_t _stat_nb_access = 0;
    uint32_t _stat_nb_update = 0;
#endif

    for (uint32_t i=0; i<_param._nb_access; i++)
      {
	// Access ... (ack is always at 1)
	if (PORT_READ (in_ACCESS_VAL[i]) == 1)
	  {
#ifdef STATISTICS
	    _stat_nb_access ++;
#endif
	    Taddress_t address;

	    if (_param._size_table>1)
	      address = PORT_READ     (in_ACCESS_ADDRESS[i]);
	    else
	      address = 0;
	    
	    reg_TABLE[address]->update(internal_ACCESS_ENTITY[i]);
	  }
      }//end for i
    
    for (uint32_t i=0; i<_param._nb_update; i++)
      {
	// Update ... (ack is always at 1)
	if (PORT_READ (in_UPDATE_VAL[i]) == 1)
	  {
#ifdef STATISTICS
	    _stat_nb_update ++;
#endif
	    
	    Taddress_t address;
	    
	    if (_param._size_table>1)
	      address = PORT_READ     (in_UPDATE_ADDRESS[i]);
	    else
	      address = 0;
	    
	    reg_TABLE[address]->update(PORT_READ(in_UPDATE_ENTITY[i]));
	  }
      }//end for i

#ifdef STATISTICS
    _stat->add(_stat_nb_access,
	       _stat_nb_update);
#endif    
    
#ifdef VHDL_TESTBENCH
    vhdl_testbench_transition ();
#endif
  };

}; // end namespace victim_pseudo_lru
}; // end namespace victim
}; // end namespace generic

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
