#ifdef VHDL_TESTBENCH
/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/include/Interfaces.h"


namespace morpheo              {
namespace behavioural          {
  
  Signal * Interfaces::get_reset (void)
  {
    Signal * reset = NULL;
    
    if (not _list_interface->empty())
      {
	list<Interface_fifo*>::iterator i     = _list_interface->begin();
	
	while (i != _list_interface->end())
	  {
	    Signal * sig = (*i)->get_reset ();

	    if (sig != NULL)
	      {
		if (reset != NULL)
		  throw ErrorMorpheo ("<Interfaces.get_reset> : find too many reset.");
		reset = sig;
	      }
	    ++i;
	  }
      }

    if (reset == NULL)
      throw ErrorMorpheo ("<Interfaces.get_reset> : no reset find.");
    
    return reset;
  };

}; // end namespace behavioural          
}; // end namespace morpheo              
#endif
