#ifdef POSITION
/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/include/Entity.h"

namespace morpheo              {
namespace behavioural          {

#undef  FUNCTION
#define FUNCTION "Entity::toXML"
  XML Entity::toXML (void)
  {
    log_printf(FUNC,Behavioural,FUNCTION,"Begin");
    
    XML xml (_name);
    
    xml.  balise_open       ("comment");
    xml.    text            (get_comment());
    xml.  balise_close      ();
    xml.  balise_open_begin ("entity");
    xml.    attribut        ("name"   ,_name);
    xml.    attribut        ("type"   ,_type);
    xml.    attribut        ("schema" ,toString(_schema));
    xml.  balise_open_end   ();
    xml.    insert_XML      (_interfaces->toXML());
    xml.  balise_close      ();
    
    log_printf(FUNC,Behavioural,FUNCTION,"End");
    
    return xml;
  };

#undef  FUNCTION
#define FUNCTION "Entity::toXML_mapping"
  XML Entity::toXML_mapping (void)
  {
    log_printf(FUNC,Behavioural,FUNCTION,"Begin");
    
    if (_is_map != true)
      throw (ErrorMorpheo ("Entity \""+_name+"\" is never mapped"));
    
    XML xml (_name);
    
    xml.  balise_open_begin ("component");
    xml.    attribut        ("name"   ,_name);
    xml.    attribut        ("type"   ,_type);
    xml.    attribut        ("size_x" ,toString(_map_size_x));
    xml.    attribut        ("size_y" ,toString(_map_size_y));
    xml.    attribut        ("pos_x"  ,toString(_map_pos_x ));
    xml.    attribut        ("pos_y"  ,toString(_map_pos_y ));

    xml.  balise_open_end   ();
    try 
      {
    xml.    insert_XML      (_interfaces->toXML_mapping());
      }
    catch (ErrorMorpheo e)
      {
	throw (ErrorMorpheo("Entity \""+_name+"\" : "+e.what()));
      }
    xml.  balise_close      ();
    
    log_printf(FUNC,Behavioural,FUNCTION,"End");

    return xml;
  };

}; // end namespace behavioural          
}; // end namespace morpheo              
#endif
