#ifdef VHDL

/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/include/Vhdl.h"

#include <sstream>
using namespace std;

namespace morpheo              {
namespace behavioural          {
  
#undef  FUNCTION
#define FUNCTION "Vhdl::set_constant"
  void Vhdl::set_constant (string      name     ,
			   string      type     ,
			   string      init)
  {
    log_printf(FUNC,Behavioural,FUNCTION,"Begin");
    set_list(_list_type, "constant "+ name+"\t: "+type+"\t:= "+init);
    log_printf(FUNC,Behavioural,FUNCTION,"End");
  };

  void Vhdl::set_constant (string      name     ,
			   uint32_t    size     ,
			   string      init)
  {
    log_printf(FUNC,Behavioural,FUNCTION,"Begin");
    set_constant(name,std_logic(size),init);
    log_printf(FUNC,Behavioural,FUNCTION,"End");
  };

  void Vhdl::set_constant (string      name     ,
			   uint32_t    size     ,
			   uint32_t    init)
  {
    log_printf(FUNC,Behavioural,FUNCTION,"Begin");
    set_constant(name,std_logic(size),std_logic_conv(size,init));
    log_printf(FUNC,Behavioural,FUNCTION,"End");
  };
  
}; // end namespace behavioural          
}; // end namespace morpheo              

#endif
