/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/include/Component.h"

namespace morpheo              {
namespace behavioural          {

#undef  FUNCTION
#define FUNCTION "Component::port_map"
  void Component::port_map (string component_src ,
			    string port_src      ,
			    string component_dest,
			    string port_dest     )
  {
    log_printf(FUNC,Behavioural,FUNCTION,"Begin");

    string name_entity = _entity->get_name();

    // First entity 
    Entity * entity_dest = find_entity(component_dest);

    if (entity_dest == NULL)
      throw (ErrorMorpheo ("<Component::port_map> in component \""+name_entity+"\", port map with unknow component \""+component_dest+"\"."));

    Signal * signal_dest = entity_dest->find_signal (port_dest);

    if (signal_dest == NULL)
      throw (ErrorMorpheo ("<Component::port_map> in component \""+name_entity+"\", port map with component \""+component_dest+"\" and a unknow signal \""+port_dest+"\"."));

    // Second entity
    Entity * entity_src = find_entity(component_src);

    if (entity_src == NULL)
      throw (ErrorMorpheo ("<Component::port_map> in component \""+name_entity+"\", port map with unknow component \""+component_src+"\"."));

    Signal * signal_src = entity_src->find_signal (port_src);

    if (signal_src == NULL)
      throw (ErrorMorpheo ("<Component::port_map> in component \""+name_entity+"\", port map with component \""+component_src+"\" and a unknow signal \""+port_src+"\"."));

    // If all is ok, mapping
    
    //cout << " - " << entity_src->get_name() << "("<< signal_src->get_name() << ")" << "\t-> " << entity_dest->get_name() << "(" << signal_dest->get_name() << ")" << endl;

    signal_src ->link   (signal_dest);
    //signal_dest->mapping(signal_src );
    
    log_printf(FUNC,Behavioural,FUNCTION,"End");
  };

}; // end namespace behavioural          
}; // end namespace morpheo              
