#ifndef morpheo_behavioural_stage_1_ifetch_predictor_meta_predictor_two_level_branch_predictor_branch_history_table_Parameters_h
#define morpheo_behavioural_stage_1_ifetch_predictor_meta_predictor_two_level_branch_predictor_branch_history_table_Parameters_h

/*
 * $Id$
 *
 * [ Description ]
 * 
 */

#include "Common/include/Debug.h"
#include "Behavioural/include/Parameters.h"
// Internal structure
#include "Behavioural/Generic/Shifter/include/Parameters.h"
#include "Behavioural/Generic/RegisterFile/RegisterFile_Monolithic/include/Parameters.h"
#include <math.h>

namespace morpheo {
namespace behavioural {
namespace stage_1_ifetch {
namespace predictor {
namespace meta_predictor {
namespace two_level_branch_predictor {
namespace branch_history_table {


  class Parameters : public morpheo::behavioural::Parameters
  {
    //-----[ fields ]------------------------------------------------------------
  public : const uint32_t _size_shifter      ;
  public : const uint32_t _nb_shifter        ;
  public : const uint32_t _nb_prediction     ;
  public : const uint32_t _nb_branch_complete;

  public :       morpheo::behavioural::generic::shifter::Parameters      * _param_shifter;
  public :       morpheo::behavioural::generic::registerfile::registerfile_monolithic::Parameters * _param_registerfile;

    //-----[ methods ]-----------------------------------------------------------
  public : Parameters  (uint32_t size_shifter      ,
 			uint32_t nb_shifter        ,
			uint32_t nb_prediction     ,
			uint32_t nb_branch_complete);
  public : Parameters  (Parameters & param) ;
  public : ~Parameters () ;

  public : string msg_error (void);

  public :        string   print      (uint32_t depth);
  public : friend ostream& operator<< (ostream& output_stream,
				       morpheo::behavioural::stage_1_ifetch::predictor::meta_predictor::two_level_branch_predictor::branch_history_table::Parameters & x);
  };

}; // end namespace branch_history_table
}; // end namespace two_level_branch_predictor
}; // end namespace meta_predictor
}; // end namespace predictor
}; // end namespace stage_1_ifetch
}; // end namespace behavioural
}; // end namespace morpheo              

#endif
