#ifdef POSITION
/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/include/Component.h"

namespace morpheo              {
namespace behavioural          {

#undef  FUNCTION
#define FUNCTION "Component::interface_map"
  void Component::interface_map (string component_src ,
				 string port_src      ,
				 string component_dest,
				 string port_dest     )
  {
    log_printf(FUNC,Behavioural,FUNCTION,"Begin");

    // First entity 
    Entity * entity_dest = find_entity(component_dest);

    string name_entity = _entity->get_name();

    if (entity_dest == NULL)
      throw (ErrorMorpheo ("<Component::interface_map> Component \""+name_entity+"\", port map with unknow component \""+component_dest+"\"."));

    bool is_top_level_dest = (name_entity == component_dest);

    Interface * interface_dest = entity_dest->find_interface(port_dest);
    
    if (interface_dest == NULL)
      throw (ErrorMorpheo ("<Component::interface_map> Component \""+name_entity+"\", port map with component \""+component_dest+"\" and a unknow interface \""+port_dest+"\"."));

    // Second entity
    Entity * entity_src = find_entity(component_src);

    if (entity_src == NULL)
      throw (ErrorMorpheo ("<Component::interface_map> Component \""+name_entity+"\", port map with unknow component \""+component_src+"\"."));

    bool is_top_level_src = (name_entity == component_src);

    Interface * interface_src = entity_src->find_interface(port_src);

    if (interface_src == NULL)
      throw (ErrorMorpheo ("<Component::interface_map> Component \""+name_entity+"\", port map with component \""+component_src+"\" and a unknow interface \""+port_src+"\"."));

    // all is ok - link
    if (is_top_level_dest == false)
      interface_dest->interface_map(static_cast<void *>(entity_src   ),
				    static_cast<void *>(interface_src));
    
    if (is_top_level_src == false)
      interface_src->interface_map(static_cast<void *>(entity_dest   ),
				   static_cast<void *>(interface_dest));
  
    log_printf(FUNC,Behavioural,FUNCTION,"End");
  };

}; // end namespace behavioural          
}; // end namespace morpheo              
#endif
