#ifndef morpheo_behavioural_stage_1_ifetch_predictor_meta_predictor_two_level_branch_predictor_two_level_branch_predictor_glue_Parameters_h
#define morpheo_behavioural_stage_1_ifetch_predictor_meta_predictor_two_level_branch_predictor_two_level_branch_predictor_glue_Parameters_h

/*
 * $Id$
 *
 * [ Description ]
 * 
 */

#include "Common/include/Debug.h"
#include "Behavioural/include/Parameters.h"
#include <math.h>

namespace morpheo {
namespace behavioural {
namespace stage_1_ifetch {
namespace predictor {
namespace meta_predictor {
namespace two_level_branch_predictor {
namespace two_level_branch_predictor_glue {


  class Parameters : public morpheo::behavioural::Parameters
  {
    //-----[ fields ]------------------------------------------------------------
  public : const bool     _have_bht              ;
  public : const uint32_t _bht_size_history      ;
  public : const uint32_t _bht_size_address      ;
  public : const bool     _have_pht              ;
  public : const uint32_t _pht_size_address      ;
  public : const uint32_t _pht_size_address_share;
  public : const uint32_t _size_address          ;
  public : const uint32_t _nb_prediction         ;
  public : const uint32_t _nb_branch_complete    ;
  public : const uint32_t _pht_size_address_shift;

    //-----[ methods ]-----------------------------------------------------------
  public : Parameters  (bool     have_bht              ,
			uint32_t bht_size_history      ,
			uint32_t bht_size_address      ,
			bool     have_pht              ,
			uint32_t pht_size_address      ,
			uint32_t pht_size_address_share,
			uint32_t size_address          ,
			uint32_t nb_prediction         ,
			uint32_t nb_branch_complete    );

  public : Parameters  (Parameters & param) ;
  public : ~Parameters () ;

  public : string msg_error (void);

  public :        string   print      (uint32_t depth);
  public : friend ostream& operator<< (ostream& output_stream,
				       morpheo::behavioural::stage_1_ifetch::predictor::meta_predictor::two_level_branch_predictor::two_level_branch_predictor_glue::Parameters & x);
  };

}; // end namespace two_level_branch_predictor_glue
}; // end namespace two_level_branch_predictor
}; // end namespace meta_predictor
}; // end namespace predictor
}; // end namespace stage_1_ifetch

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
