/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Stage_1_Ifetch/Predictor/Meta_Predictor/SelfTest/include/test.h"

#define NB_PARAMS 25

void usage (string exec)
{
  cerr << "<Usage> " << exec << " name_instance list_params" << endl
       << "list_params is :" << endl
       << " - have_meta_predictor                (bool    )" << endl
       << " - predictor_0_have_bht               (bool    )" << endl
       << " - predictor_0_bht_size_shifter       (uint32_t)" << endl
       << " - predictor_0_bht_nb_shifter         (uint32_t)" << endl
       << " - predictor_0_have_pht               (bool    )" << endl
       << " - predictor_0_pht_size_counter       (uint32_t)" << endl
       << " - predictor_0_pht_nb_counter         (uint32_t)" << endl
       << " - predictor_0_pht_size_address_share (uint32_t)" << endl
       << " - predictor_1_have_bht               (bool    )" << endl
       << " - predictor_1_bht_size_shifter       (uint32_t)" << endl
       << " - predictor_1_bht_nb_shifter         (uint32_t)" << endl
       << " - predictor_1_have_pht               (bool    )" << endl
       << " - predictor_1_pht_size_counter       (uint32_t)" << endl
       << " - predictor_1_pht_nb_counter         (uint32_t)" << endl
       << " - predictor_1_pht_size_address_share (uint32_t)" << endl
       << " - predictor_2_have_bht               (bool    )" << endl
       << " - predictor_2_bht_size_shifter       (uint32_t)" << endl
       << " - predictor_2_bht_nb_shifter         (uint32_t)" << endl
       << " - predictor_2_have_pht               (bool    )" << endl
       << " - predictor_2_pht_size_counter       (uint32_t)" << endl
       << " - predictor_2_pht_nb_counter         (uint32_t)" << endl
       << " - predictor_2_pht_size_address_share (uint32_t)" << endl
       << " - size_address                       (uint32_t)" << endl
       << " - nb_prediction                      (uint32_t)" << endl
       << " - nb_branch_complete                 (uint32_t)" << endl;

  exit (1);
}

#ifndef SYSTEMC
int main    (int argc, char * argv[])
#else
int sc_main (int argc, char * argv[])
#endif
{
  if (argc != 2+NB_PARAMS)
    usage (argv[0]);

  const string   name                              = argv[1];

  const bool     have_meta_predictor               = atoi(argv[ 2]);

  const bool     predictor_0_have_bht              = atoi(argv[ 3]);
  const uint32_t predictor_0_bht_size_shifter      = atoi(argv[ 4]);
  const uint32_t predictor_0_bht_nb_shifter        = atoi(argv[ 5]);
  const bool     predictor_0_have_pht              = atoi(argv[ 6]);
  const uint32_t predictor_0_pht_size_counter      = atoi(argv[ 7]);
  const uint32_t predictor_0_pht_nb_counter        = atoi(argv[ 8]);
  const uint32_t predictor_0_pht_size_address_share= atoi(argv[ 9]);

  const bool     predictor_1_have_bht              = atoi(argv[10]);
  const uint32_t predictor_1_bht_size_shifter      = atoi(argv[11]);
  const uint32_t predictor_1_bht_nb_shifter        = atoi(argv[12]);
  const bool     predictor_1_have_pht              = atoi(argv[13]);
  const uint32_t predictor_1_pht_size_counter      = atoi(argv[14]);
  const uint32_t predictor_1_pht_nb_counter        = atoi(argv[15]);
  const uint32_t predictor_1_pht_size_address_share= atoi(argv[16]);

  const bool     predictor_2_have_bht              = atoi(argv[17]);
  const uint32_t predictor_2_bht_size_shifter      = atoi(argv[18]);
  const uint32_t predictor_2_bht_nb_shifter        = atoi(argv[19]);
  const bool     predictor_2_have_pht              = atoi(argv[20]);
  const uint32_t predictor_2_pht_size_counter      = atoi(argv[21]);
  const uint32_t predictor_2_pht_nb_counter        = atoi(argv[22]);
  const uint32_t predictor_2_pht_size_address_share= atoi(argv[23]);

  const uint32_t size_address                      = atoi(argv[24]);
  const uint32_t nb_prediction                     = atoi(argv[25]);
  const uint32_t nb_branch_complete                = atoi(argv[26]);

  try 
    {
      morpheo::behavioural::stage_1_ifetch::predictor::meta_predictor::Parameters param (have_meta_predictor               ,
											 predictor_0_have_bht              ,
											 predictor_0_bht_size_shifter      ,
											 predictor_0_bht_nb_shifter        ,
											 predictor_0_have_pht              ,
											 predictor_0_pht_size_counter      ,
											 predictor_0_pht_nb_counter        ,
											 predictor_0_pht_size_address_share,
											 predictor_1_have_bht              ,
											 predictor_1_bht_size_shifter      ,
											 predictor_1_bht_nb_shifter        ,
											 predictor_1_have_pht              ,
											 predictor_1_pht_size_counter      ,
											 predictor_1_pht_nb_counter        ,
											 predictor_1_pht_size_address_share,
											 predictor_2_have_bht              ,
											 predictor_2_bht_size_shifter      ,
											 predictor_2_bht_nb_shifter        ,
											 predictor_2_have_pht              ,
											 predictor_2_pht_size_counter      ,
											 predictor_2_pht_nb_counter        ,
											 predictor_2_pht_size_address_share,
											 size_address                      ,
											 nb_prediction                     ,
											 nb_branch_complete                );
      
      cout << param.print(1);
      
      test (name,param);
    }
  catch (morpheo::ErrorMorpheo & error)
    {
      cout << "<" << name << "> : " <<  error.what ();
      exit (EXIT_FAILURE);
    }
  catch (...)
    {
      cerr << "<" << name << "> : This test must generate a error" << endl;
      exit (EXIT_FAILURE);
    }

  return (EXIT_SUCCESS);
}

