#ifndef morpheo_behavioural_stage_1_ifetch_predictor_meta_predictor_two_level_branch_predictor_Two_Level_Branch_Predictor_h
#define morpheo_behavioural_stage_1_ifetch_predictor_meta_predictor_two_level_branch_predictor_Two_Level_Branch_Predictor_h

/*
 * $Id$
 *
 * [Description ]
 * 
 */

#ifdef SYSTEMC
#include "systemc.h"
#endif

#include <iostream>
#include "Common/include/ToString.h"
#include "Common/include/Debug.h"

// Internal structure
#include "Behavioural/Stage_1_Ifetch/Predictor/Meta_Predictor/Two_Level_Branch_Predictor/Branch_History_Table/include/Branch_History_Table.h"
#include "Behavioural/Stage_1_Ifetch/Predictor/Meta_Predictor/Two_Level_Branch_Predictor/Pattern_History_Table/include/Pattern_History_Table.h"
#include "Behavioural/Stage_1_Ifetch/Predictor/Meta_Predictor/Two_Level_Branch_Predictor/Two_Level_Branch_Predictor_Glue/include/Two_Level_Branch_Predictor_Glue.h"

#include "Behavioural/Stage_1_Ifetch/Predictor/Meta_Predictor/Two_Level_Branch_Predictor/include/Parameters.h"
#include "Behavioural/Stage_1_Ifetch/Predictor/Meta_Predictor/Two_Level_Branch_Predictor/include/Types.h"
#ifdef STATISTICS
#include "Behavioural/Stage_1_Ifetch/Predictor/Meta_Predictor/Two_Level_Branch_Predictor/include/Statistics.h"
#endif
#ifdef VHDL
#include "Behavioural/include/Vhdl.h"
#endif
#include "Behavioural/include/Component.h"

using namespace std;

namespace morpheo {
namespace behavioural {
namespace stage_1_ifetch {
namespace predictor {
namespace meta_predictor {
namespace two_level_branch_predictor {


  class Two_Level_Branch_Predictor 
#if SYSTEMC
    : public sc_module
#endif
  {
    // -----[fields ]----------------------------------------------------
    // Parameters
  protected : const string     _name;

  protected : const Parameters _param;
#ifdef STATISTICS
 protected : const morpheo::behavioural::Parameters_Statistics _param_statistics;
#endif

#ifdef STATISTICS
  private   : Statistics                     * _stat;
#endif

  public    : Component                      * _component;
  private   : Interfaces                     * _interfaces;

#ifdef SYSTEMC
    // ~~~~~[Interface ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // Interface
  public    : SC_CLOCK                      *  in_CLOCK                      ;
  public    : SC_IN (Tcontrol_t)            *  in_NRESET                     ;
    // Interface Predict
  public    : SC_IN (Tcontrol_t)           **  in_PREDICT_VAL                ;
  public    : SC_OUT(Tcontrol_t)           ** out_PREDICT_ACK                ;
  public    : SC_IN (Taddress_t)           **  in_PREDICT_ADDRESS            ;
  public    : SC_OUT(Tbht_history_t)       ** out_PREDICT_BHT_HISTORY        ;
  public    : SC_OUT(Tpht_history_t)       ** out_PREDICT_PHT_HISTORY        ;
			
    // Interface Branch_complete
  public    : SC_IN (Tcontrol_t)           **  in_BRANCH_COMPLETE_VAL        ;
  public    : SC_OUT(Tcontrol_t)           ** out_BRANCH_COMPLETE_ACK        ;
  public    : SC_IN (Taddress_t)           **  in_BRANCH_COMPLETE_ADDRESS    ;
  public    : SC_IN (Tbht_history_t)       **  in_BRANCH_COMPLETE_BHT_HISTORY;
  public    : SC_IN (Tpht_history_t)       **  in_BRANCH_COMPLETE_PHT_HISTORY;
  public    : SC_IN (Tcontrol_t)           **  in_BRANCH_COMPLETE_DIRECTION  ;

    // ~~~~~[Register ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    // ~~~~~[Internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  private   : SC_SIGNAL(Tcontrol_t)        ** signal_PREDICT_BHT_ACK            ;
  private   : SC_SIGNAL(Tcontrol_t)        ** signal_PREDICT_PHT_ACK            ;
  private   : SC_SIGNAL(Taddress_t)        ** signal_PREDICT_BHT_ADDRESS        ;
  private   : SC_SIGNAL(Taddress_t)        ** signal_PREDICT_PHT_ADDRESS        ;

  private   : SC_SIGNAL(Tcontrol_t)        ** signal_BRANCH_COMPLETE_BHT_ACK    ;
  private   : SC_SIGNAL(Tcontrol_t)        ** signal_BRANCH_COMPLETE_PHT_ACK    ;
  private   : SC_SIGNAL(Taddress_t)        ** signal_BRANCH_COMPLETE_BHT_ADDRESS; 
  private   : SC_SIGNAL(Taddress_t)        ** signal_BRANCH_COMPLETE_PHT_ADDRESS;
#endif

    // ~~~~~[Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
  protected : morpheo::behavioural::stage_1_ifetch::predictor::meta_predictor::two_level_branch_predictor::branch_history_table ::Branch_History_Table  * component_Branch_History_Table;
  protected : morpheo::behavioural::stage_1_ifetch::predictor::meta_predictor::two_level_branch_predictor::pattern_history_table::Pattern_History_Table * component_Pattern_History_Table;
  protected : morpheo::behavioural::stage_1_ifetch::predictor::meta_predictor::two_level_branch_predictor::two_level_branch_predictor_glue::Two_Level_Branch_Predictor_Glue * component_Two_Level_Branch_Predictor_Glue;

    // -----[methods ]---------------------------------------------------

#ifdef SYSTEMC
    SC_HAS_PROCESS (Two_Level_Branch_Predictor);
#endif					       
  public  :          Two_Level_Branch_Predictor              (
#ifdef SYSTEMC
							      sc_module_name                              name,
#else					       
							      string                                      name,
#endif					       
#ifdef STATISTICS
							      morpheo::behavioural::Parameters_Statistics param_statistics,
#endif
							      Parameters                                  param );
							      
  public  :          Two_Level_Branch_Predictor              (Parameters param );
  public  :          ~Two_Level_Branch_Predictor             (void);
					       
#ifdef SYSTEMC				       
  private : void     allocation                (void);
  private : void     deallocation              (void);
					       
#if (defined(STATISTICS) || defined (VHDL_TESTBENCH))
  public  : void     transition                (void);
#endif
#endif					       
#ifdef STATISTICS
  public  : string   statistics                (uint32_t depth);
#endif
					       
#if VHDL				       
  public  : void     vhdl                      (void);
  private : void     vhdl_declaration          (Vhdl * & vhdl);
  private : void     vhdl_body                 (Vhdl * & vhdl);
#endif					       
#ifdef VHDL_TESTBENCH			       
  private : void     vhdl_testbench_transition (void);
#endif
  };

}; // end namespace two_level_branch_predictor
}; // end namespace meta_predictor
}; // end namespace predictor
}; // end namespace stage_1_ifetch

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
