#ifndef morpheo_behavioural_core_multi_front_end_front_end_prediction_unit_direction_meta_predictor_meta_predictor_glue_Meta_Predictor_Glue_h
#define morpheo_behavioural_core_multi_front_end_front_end_prediction_unit_direction_meta_predictor_meta_predictor_glue_Meta_Predictor_Glue_h

/*
 * $Id$
 *
 * [Description ]
 * 
 */

#ifdef SYSTEMC
#include "systemc.h"
#endif

#include <iostream>
#include "Common/include/ToString.h"
#include "Common/include/Debug.h"

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Direction/Meta_Predictor/Meta_Predictor_Glue/include/Parameters.h"
#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Direction/Meta_Predictor/Meta_Predictor_Glue/include/Types.h"
#ifdef STATISTICS
#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Direction/Meta_Predictor/Meta_Predictor_Glue/include/Statistics.h"
#endif
#ifdef VHDL
#include "Behavioural/include/Vhdl.h"
#endif
#include "Behavioural/include/Component.h"

using namespace std;

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace direction {

namespace meta_predictor {
namespace meta_predictor_glue {


  class Meta_Predictor_Glue 
#if SYSTEMC
    : public sc_module
#endif
  {
    // -----[fields ]----------------------------------------------------
    // Parameters
  protected : const string     _name;

  protected : const Parameters _param;
//#ifdef STATISTICS
//  protected : const morpheo::behavioural::Parameters_Statistics _param_statistics;
//#endif

#ifdef STATISTICS
  private   : Statistics                     * _stat;
#endif

  public    : Component                      * _component;
  private   : Interfaces                     * _interfaces;

#ifdef SYSTEMC
    // ~~~~~[Interface ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // Interface
  public    : SC_CLOCK                      *  in_CLOCK                                  ;
  public    : SC_IN (Tcontrol_t)            *  in_NRESET                                 ;

    // Interface Predict
  public    : SC_IN (Tcontrol_t)           **  in_PREDICT_PREDICTOR_0_ACK                ;
  public    : SC_IN (Tcontrol_t)           **  in_PREDICT_PREDICTOR_1_ACK                ;
  public    : SC_IN (Tcontrol_t)           **  in_PREDICT_PREDICTOR_2_ACK                ;
  public    : SC_OUT(Tcontrol_t)           ** out_PREDICT_ACK                            ;

  public    : SC_IN (Tbht_history_t)       **  in_PREDICT_PREDICTOR_0_BHT_HISTORY        ;
  public    : SC_IN (Tpht_history_t)       **  in_PREDICT_PREDICTOR_0_PHT_HISTORY        ;
  public    : SC_IN (Tbht_history_t)       **  in_PREDICT_PREDICTOR_1_BHT_HISTORY        ;
  public    : SC_IN (Tpht_history_t)       **  in_PREDICT_PREDICTOR_1_PHT_HISTORY        ;
  public    : SC_IN (Tbht_history_t)       **  in_PREDICT_PREDICTOR_2_BHT_HISTORY        ;
  public    : SC_IN (Tpht_history_t)       **  in_PREDICT_PREDICTOR_2_PHT_HISTORY        ;
  public    : SC_OUT(Thistory_t)           ** out_PREDICT_HISTORY                        ;
  public    : SC_OUT(Tcontrol_t)           ** out_PREDICT_DIRECTION                      ;

    // Interface Branch_complete
  public    : SC_IN (Tcontrol_t)           **  in_BRANCH_COMPLETE_VAL                    ;
  public    : SC_OUT(Tcontrol_t)           ** out_BRANCH_COMPLETE_PREDICTOR_2_VAL        ;

  public    : SC_IN (Tcontrol_t)           **  in_BRANCH_COMPLETE_PREDICTOR_0_ACK        ;
  public    : SC_IN (Tcontrol_t)           **  in_BRANCH_COMPLETE_PREDICTOR_1_ACK        ;
  public    : SC_IN (Tcontrol_t)           **  in_BRANCH_COMPLETE_PREDICTOR_2_ACK        ;
  public    : SC_OUT(Tcontrol_t)           ** out_BRANCH_COMPLETE_ACK                    ;

  public    : SC_OUT(Tbht_history_t)       ** out_BRANCH_COMPLETE_PREDICTOR_0_BHT_HISTORY;
  public    : SC_OUT(Tpht_history_t)       ** out_BRANCH_COMPLETE_PREDICTOR_0_PHT_HISTORY;
  public    : SC_OUT(Tbht_history_t)       ** out_BRANCH_COMPLETE_PREDICTOR_1_BHT_HISTORY;
  public    : SC_OUT(Tpht_history_t)       ** out_BRANCH_COMPLETE_PREDICTOR_1_PHT_HISTORY;
  public    : SC_OUT(Tbht_history_t)       ** out_BRANCH_COMPLETE_PREDICTOR_2_BHT_HISTORY;
  public    : SC_OUT(Tpht_history_t)       ** out_BRANCH_COMPLETE_PREDICTOR_2_PHT_HISTORY;
  public    : SC_IN (Thistory_t)           **  in_BRANCH_COMPLETE_HISTORY                ;
  public    : SC_IN (Tcontrol_t)           **  in_BRANCH_COMPLETE_DIRECTION              ;
  public    : SC_OUT(Tcontrol_t)           ** out_BRANCH_COMPLETE_PREDICTOR_2_DIRECTION  ;

    // ~~~~~[Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    // ~~~~~[Register ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    // ~~~~~[Internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#endif

    // -----[methods ]---------------------------------------------------

#ifdef SYSTEMC
    SC_HAS_PROCESS (Meta_Predictor_Glue);
#endif
  public  :          Meta_Predictor_Glue              (
#ifdef SYSTEMC
					      sc_module_name                              name,
#else					       
					      string                                      name,
#endif					       
#ifdef STATISTICS
					      morpheo::behavioural::Parameters_Statistics param_statistics,
#endif
					      Parameters                                  param );
					       
  public  :          Meta_Predictor_Glue              (Parameters param );
  public  :          ~Meta_Predictor_Glue             (void);
					       
#ifdef SYSTEMC				       
  private : void     allocation                (void);
  private : void     deallocation              (void);
				
#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
  public  : void     transition                       (void);
#endif
  public  : void     genMealy_predict_ack             (void);
  public  : void     genMealy_predict_history         (void);
  public  : void     genMealy_branch_complete_val     (void);
  public  : void     genMealy_branch_complete_ack     (void);
  public  : void     genMealy_branch_complete_history (void);

#endif					       
#ifdef STATISTICS
  public  : string   statistics                (uint32_t depth);
#endif
					       
#if VHDL				       
  public  : void     vhdl                      (void);
  private : void     vhdl_declaration          (Vhdl * & vhdl);
  private : void     vhdl_body                 (Vhdl * & vhdl);
#endif					       
#ifdef VHDL_TESTBENCH			       
  private : void     vhdl_testbench_transition (void);
#endif
  };

}; // end namespace meta_predictor_glue
}; // end namespace meta_predictor

}; // end namespace core
}; // end namespace multi_front_end
}; // end namespace front_end
}; // end namespace prediction_unit
}; // end namespace direction


}; // end namespace behavioural
}; // end namespace morpheo              

#endif
