/*
 * $Id$
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Direction/Meta_Predictor/Two_Level_Branch_Predictor/Pattern_History_Table/include/Parameters.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace direction {

namespace meta_predictor {
namespace two_level_branch_predictor {
namespace pattern_history_table {


  Parameters::Parameters (uint32_t size_counter      ,
 			  uint32_t nb_counter        ,
			  uint32_t nb_prediction     ,
			  uint32_t nb_branch_complete) :
    _size_counter       (size_counter      ),
    _nb_counter         (nb_counter        ),
    _nb_prediction      (nb_prediction     ),
    _nb_branch_complete (nb_branch_complete)
  {
    log_printf(FUNC,Pattern_History_Table,"Parameters","Begin");

    _param_counter      = new morpheo::behavioural::generic::counter::Parameters (size_counter       ,
										  nb_branch_complete );
    _param_registerfile = new morpheo::behavioural::generic::registerfile::registerfile_monolithic::Parameters (nb_prediction      ,
														nb_branch_complete ,
														nb_counter         ,
														size_counter       );
    

    test();
    log_printf(FUNC,Pattern_History_Table,"Parameters","End");
  };
  
  Parameters::Parameters (Parameters & param) :
    _size_counter       (param._size_counter      ),
    _nb_counter         (param._nb_counter        ),
    _nb_prediction      (param._nb_prediction     ),
    _nb_branch_complete (param._nb_branch_complete)
  {
    log_printf(FUNC,Pattern_History_Table,"Parameters","Begin");

    _param_counter = new morpheo::behavioural::generic::counter::Parameters (param._size_counter       ,
									     param._nb_branch_complete );

    _param_registerfile = new morpheo::behavioural::generic::registerfile::registerfile_monolithic::Parameters (param._nb_prediction      ,
														param._nb_branch_complete ,
														param._nb_counter         ,
														param._size_counter       );
    
    test();
    log_printf(FUNC,Pattern_History_Table,"Parameters","End");
  };

  Parameters::~Parameters () 
  {
    log_printf(FUNC,Pattern_History_Table,"~Parameters","Begin");
    delete _param_counter;
    delete _param_registerfile;
    log_printf(FUNC,Pattern_History_Table,"~Parameters","End");
  };

}; // end namespace pattern_history_table
}; // end namespace two_level_branch_predictor
}; // end namespace meta_predictor

}; // end namespace core
}; // end namespace multi_front_end
}; // end namespace front_end
}; // end namespace prediction_unit
}; // end namespace direction

}; // end namespace behavioural
}; // end namespace morpheo              
