#ifdef SYSTEMC
/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Direction/Meta_Predictor/include/Meta_Predictor.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace direction {

namespace meta_predictor {


  void Meta_Predictor::allocation (void)
  {
    log_printf(FUNC,Meta_Predictor,"allocation","Begin");

    _component   = new Component ();

    Entity * entity = _component->set_entity (_name                 
					     ,"Meta_Predictor"
#ifdef POSITION
					     ,MIXTE
#endif
					      );
    
    _interfaces = entity->set_interfaces();

    // ~~~~~[Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      Interface * interface = _interfaces->set_interface(""
#ifdef POSITION
							 , IN  
							 , SOUTH
							 , "Generalist interface"
#endif
							 );
      
      in_CLOCK              = interface->set_signal_clk              ("clock" ,1);
      in_NRESET             = interface->set_signal_in  <Tcontrol_t> ("nreset",1,RESET_VHDL_YES);
    }

    // ~~~~~[Interface : "predict" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

     in_PREDICT_VAL                 = new SC_IN (Tcontrol_t)     * [_param._nb_prediction     ];
    out_PREDICT_ACK                 = new SC_OUT(Tcontrol_t)     * [_param._nb_prediction     ];
     in_PREDICT_ADDRESS             = new SC_IN (Taddress_t)     * [_param._nb_prediction     ];
    out_PREDICT_HISTORY             = new SC_OUT(Thistory_t)     * [_param._nb_prediction     ];
    out_PREDICT_DIRECTION           = new SC_OUT(Tcontrol_t)     * [_param._nb_prediction     ];

    for (uint32_t i=0; i<_param._nb_prediction; i++)
      {
	Interface_fifo * interface = _interfaces->set_interface("predict_"+toString(i)
#ifdef POSITION
								, IN  
								, WEST
								, "Interface Predict"
#endif
								);

	 in_PREDICT_VAL                 [i] = interface->set_signal_valack_in        ("val"      , VAL);
	out_PREDICT_ACK                 [i] = interface->set_signal_valack_out       ("ack"      , ACK);
	 in_PREDICT_ADDRESS             [i] = interface->set_signal_in  <Taddress_t> ("address"  , _param._size_address);
	out_PREDICT_HISTORY             [i] = interface->set_signal_out <Thistory_t> ("history"  , _param._size_history);
	out_PREDICT_DIRECTION           [i] = interface->set_signal_out <Tcontrol_t> ("direction", 1);
      }

    // ~~~~~[Interface : "branch_complete" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

     in_BRANCH_COMPLETE_VAL         = new SC_IN (Tcontrol_t)     * [_param._nb_branch_complete];
    out_BRANCH_COMPLETE_ACK         = new SC_OUT(Tcontrol_t)     * [_param._nb_branch_complete];
     in_BRANCH_COMPLETE_ADDRESS     = new SC_IN (Taddress_t)     * [_param._nb_branch_complete];
     in_BRANCH_COMPLETE_HISTORY     = new SC_IN (Thistory_t)     * [_param._nb_branch_complete];
     in_BRANCH_COMPLETE_DIRECTION   = new SC_IN (Tcontrol_t)     * [_param._nb_branch_complete];

    for (uint32_t i=0; i<_param._nb_branch_complete; i++)
      {
	Interface_fifo * interface = _interfaces->set_interface("branch_complete_"+toString(i)
#ifdef POSITION
								, IN  
								, EAST
								, "Interface branch complete"
#endif
								);

	 in_BRANCH_COMPLETE_VAL         [i] = interface->set_signal_valack_in        ("val"        , VAL);		   
	out_BRANCH_COMPLETE_ACK         [i] = interface->set_signal_valack_out       ("ack"        , ACK);		   
	 in_BRANCH_COMPLETE_ADDRESS     [i] = interface->set_signal_in  <Taddress_t> ("address"    , _param._size_address);
	 in_BRANCH_COMPLETE_HISTORY     [i] = interface->set_signal_in  <Thistory_t> ("history"    , _param._size_history);
	 in_BRANCH_COMPLETE_DIRECTION   [i] = interface->set_signal_in  <Tcontrol_t> ("direction"  , 1);
      }

    // ~~~~~[Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    string name_component;

    // =====[component_Meta_Predictor_Glue ]=============================

    name_component = _name+"_Meta_Predictor_Glue";
    
    log_printf(INFO,Meta_Predictor,"allocation","Allocation : %s",name_component.c_str());
    
    component_Meta_Predictor_Glue = new morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::direction::meta_predictor::meta_predictor_glue::Meta_Predictor_Glue (name_component.c_str()               ,
#ifdef STATISTICS	
																		   _param_statistics                    ,
#endif
																		   *(_param._param_meta_predictor_glue));
    
    
    _component->set_component (component_Meta_Predictor_Glue->_component
#ifdef POSITION
			       , 75
			       , 25
			       , 10
			       , 10
#endif
			       );
    

    // =====[component_Two_Level_Branch_Predictor_2 ]====================    

    name_component = _name+"_Two_Level_Branch_Predictor_2";
    
    log_printf(INFO,Meta_Predictor,"allocation","Allocation : %s",name_component.c_str());
    
    component_Two_Level_Branch_Predictor_2 = new morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::direction::meta_predictor::two_level_branch_predictor ::Two_Level_Branch_Predictor (name_component.c_str()               ,
#ifdef STATISTICS	
																					   _param_statistics                    ,
#endif
																					   *(_param._param_two_level_branch_predictor_2));
    

    _component->set_component (component_Two_Level_Branch_Predictor_2->_component
#ifdef POSITION
			       , 75
			       , 25
			       , 10
			       , 10
#endif
			       );
    


    if (_param._have_meta_predictor)
      {
    // =====[component_Two_Level_Branch_Predictor_1 ]====================    

    name_component = _name+"_Two_Level_Branch_Predictor_1";
    
    log_printf(INFO,Meta_Predictor,"allocation","Allocation : %s",name_component.c_str());
    
    component_Two_Level_Branch_Predictor_1 = new morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::direction::meta_predictor::two_level_branch_predictor ::Two_Level_Branch_Predictor (name_component.c_str()               ,
#ifdef STATISTICS	
																					   _param_statistics                    ,
#endif
																					   *(_param._param_two_level_branch_predictor_1));

    _component->set_component (component_Two_Level_Branch_Predictor_1->_component
#ifdef POSITION
			       , 75
			       , 25
			       , 10
			       , 10
#endif
			       );

    // =====[component_Two_Level_Branch_Predictor_0 ]====================    

    name_component = _name+"_Two_Level_Branch_Predictor_0";
    
    log_printf(INFO,Meta_Predictor,"allocation","Allocation : %s",name_component.c_str());
    
    component_Two_Level_Branch_Predictor_0 = new morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::direction::meta_predictor::two_level_branch_predictor ::Two_Level_Branch_Predictor (name_component.c_str()               ,
#ifdef STATISTICS	
																					   _param_statistics                    ,
#endif
																					   *(_param._param_two_level_branch_predictor_0));
    
    _component->set_component (component_Two_Level_Branch_Predictor_0->_component
#ifdef POSITION
			       , 75
			       , 25
			       , 10
			       , 10
#endif
			       );
      
      }

    // ~~~~~[Component - Instanciation ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

    // =====[component_Meta_Predictor_Glue - Instanciation ]=============

    name_component = _name+"_Meta_Predictor_Glue";

    cout << "Instance : " << name_component << endl;

#ifdef POSITION
    _component->interface_map ("Meta_Predictor_Glue","",
			       _name                ,"");
#endif
    
    _component->port_map(name_component, "in_CLOCK" , _name,"in_CLOCK" );
    _component->port_map(name_component, "in_NRESET", _name,"in_NRESET");
    
    // Interface Predict
    for (uint32_t i=0; i<_param._nb_prediction; i++)
      {
#ifdef POSITION
	_component->interface_map ("Meta_Predictor_Glue","predict_"+toString(i),
				   _name                ,"predict_"+toString(i));
#endif
	
	if (_param._have_meta_predictor)
	  {
	_component->port_map(name_component,  "in_PREDICT_"+toString(i)+"_PREDICTOR_0_ACK"        , _name+"_Two_Level_Branch_Predictor_0" ,"out_PREDICT_"+toString(i)+"_ACK");
	_component->port_map(name_component,  "in_PREDICT_"+toString(i)+"_PREDICTOR_1_ACK"        , _name+"_Two_Level_Branch_Predictor_1" ,"out_PREDICT_"+toString(i)+"_ACK");
	  }
	_component->port_map(name_component,  "in_PREDICT_"+toString(i)+"_PREDICTOR_2_ACK"        , _name+"_Two_Level_Branch_Predictor_2" ,"out_PREDICT_"+toString(i)+"_ACK");
	_component->port_map(name_component, "out_PREDICT_"+toString(i)+"_ACK"                    , _name , "out_PREDICT_"+toString(i)+"_ACK");
	if (_param._have_meta_predictor)
	  {									      		  	      
	if (_param._predictor_0_have_bht)
	_component->port_map(name_component,  "in_PREDICT_"+toString(i)+"_PREDICTOR_0_BHT_HISTORY", _name+"_Two_Level_Branch_Predictor_0" ,"out_PREDICT_"+toString(i)+"_BHT_HISTORY");
	if (_param._predictor_0_have_pht)
	_component->port_map(name_component,  "in_PREDICT_"+toString(i)+"_PREDICTOR_0_PHT_HISTORY", _name+"_Two_Level_Branch_Predictor_0" ,"out_PREDICT_"+toString(i)+"_PHT_HISTORY");
	if (_param._predictor_1_have_bht)
	_component->port_map(name_component,  "in_PREDICT_"+toString(i)+"_PREDICTOR_1_BHT_HISTORY", _name+"_Two_Level_Branch_Predictor_1" ,"out_PREDICT_"+toString(i)+"_BHT_HISTORY");
	if (_param._predictor_1_have_pht)
	_component->port_map(name_component,  "in_PREDICT_"+toString(i)+"_PREDICTOR_1_PHT_HISTORY", _name+"_Two_Level_Branch_Predictor_1" ,"out_PREDICT_"+toString(i)+"_PHT_HISTORY");
	  }									      		  	      
	if (_param._predictor_2_have_bht)
	_component->port_map(name_component,  "in_PREDICT_"+toString(i)+"_PREDICTOR_2_BHT_HISTORY", _name+"_Two_Level_Branch_Predictor_2" ,"out_PREDICT_"+toString(i)+"_BHT_HISTORY");
	if (_param._predictor_2_have_pht)
	_component->port_map(name_component,  "in_PREDICT_"+toString(i)+"_PREDICTOR_2_PHT_HISTORY", _name+"_Two_Level_Branch_Predictor_2" ,"out_PREDICT_"+toString(i)+"_PHT_HISTORY");
	_component->port_map(name_component, "out_PREDICT_"+toString(i)+"_HISTORY"                , _name , "out_PREDICT_"+toString(i)+"_HISTORY");
	_component->port_map(name_component, "out_PREDICT_"+toString(i)+"_DIRECTION"              , _name , "out_PREDICT_"+toString(i)+"_DIRECTION");
      }

    for (uint32_t i=0; i<_param._nb_branch_complete; i++)
      {
#ifdef POSITION
	_component->interface_map ("Meta_Predictor_Glue","branch_complete_"+toString(i),
				   _name                ,"branch_complete_"+toString(i));
#endif

	if (_param._have_meta_predictor)
	  {
	_component->port_map(name_component,  "in_BRANCH_COMPLETE_"+toString(i)+"_VAL"                     , _name , "in_BRANCH_COMPLETE_"+toString(i)+"_VAL");
	_component->port_map(name_component, "out_BRANCH_COMPLETE_"+toString(i)+"_PREDICTOR_2_VAL"         , _name+"_Two_Level_Branch_Predictor_2",  "in_BRANCH_COMPLETE_"+toString(i)+"_VAL");

	_component->port_map(name_component,  "in_BRANCH_COMPLETE_"+toString(i)+"_PREDICTOR_0_ACK"         , _name+"_Two_Level_Branch_Predictor_0", "out_BRANCH_COMPLETE_"+toString(i)+"_ACK");
	_component->port_map(name_component,  "in_BRANCH_COMPLETE_"+toString(i)+"_PREDICTOR_1_ACK"         , _name+"_Two_Level_Branch_Predictor_1", "out_BRANCH_COMPLETE_"+toString(i)+"_ACK");
	  }					
	_component->port_map(name_component,  "in_BRANCH_COMPLETE_"+toString(i)+"_PREDICTOR_2_ACK"         , _name+"_Two_Level_Branch_Predictor_2", "out_BRANCH_COMPLETE_"+toString(i)+"_ACK");
	_component->port_map(name_component, "out_BRANCH_COMPLETE_"+toString(i)+"_ACK"                     , _name ,"out_BRANCH_COMPLETE_"+toString(i)+"_ACK");
						
	if (_param._have_meta_predictor)	
	  {					
	if (_param._predictor_0_have_bht)
	_component->port_map(name_component, "out_BRANCH_COMPLETE_"+toString(i)+"_PREDICTOR_0_BHT_HISTORY" , _name+"_Two_Level_Branch_Predictor_0",  "in_BRANCH_COMPLETE_"+toString(i)+"_BHT_HISTORY" );
	if (_param._predictor_0_have_pht)
	_component->port_map(name_component, "out_BRANCH_COMPLETE_"+toString(i)+"_PREDICTOR_0_PHT_HISTORY" , _name+"_Two_Level_Branch_Predictor_0",  "in_BRANCH_COMPLETE_"+toString(i)+"_PHT_HISTORY" );
	if (_param._predictor_1_have_bht)
	_component->port_map(name_component, "out_BRANCH_COMPLETE_"+toString(i)+"_PREDICTOR_1_BHT_HISTORY" , _name+"_Two_Level_Branch_Predictor_1",  "in_BRANCH_COMPLETE_"+toString(i)+"_BHT_HISTORY" );
	if (_param._predictor_1_have_pht)
	_component->port_map(name_component, "out_BRANCH_COMPLETE_"+toString(i)+"_PREDICTOR_1_PHT_HISTORY" , _name+"_Two_Level_Branch_Predictor_1",  "in_BRANCH_COMPLETE_"+toString(i)+"_PHT_HISTORY" );
	  }					
	if (_param._predictor_2_have_bht)
	_component->port_map(name_component, "out_BRANCH_COMPLETE_"+toString(i)+"_PREDICTOR_2_BHT_HISTORY" , _name+"_Two_Level_Branch_Predictor_2",  "in_BRANCH_COMPLETE_"+toString(i)+"_BHT_HISTORY" );
	if (_param._predictor_2_have_pht)
	_component->port_map(name_component, "out_BRANCH_COMPLETE_"+toString(i)+"_PREDICTOR_2_PHT_HISTORY" , _name+"_Two_Level_Branch_Predictor_2",  "in_BRANCH_COMPLETE_"+toString(i)+"_PHT_HISTORY" );
	_component->port_map(name_component,  "in_BRANCH_COMPLETE_"+toString(i)+"_HISTORY"                 , _name , "in_BRANCH_COMPLETE_"+toString(i)+"_HISTORY");
	if (_param._have_meta_predictor)	
	  {
	_component->port_map(name_component,  "in_BRANCH_COMPLETE_"+toString(i)+"_DIRECTION"               , _name , "in_BRANCH_COMPLETE_"+toString(i)+"_DIRECTION");
	_component->port_map(name_component, "out_BRANCH_COMPLETE_"+toString(i)+"_PREDICTOR_2_DIRECTION"   , _name+"_Two_Level_Branch_Predictor_2" , "in_BRANCH_COMPLETE_"+toString(i)+"_DIRECTION");
	  }
      }

    // =====[component_Two_Level_Branch_Predictor_2 - Instanciation ]====
    name_component = _name+"_Two_Level_Branch_Predictor_2";

    cout << "Instance : " << name_component << endl;

#ifdef POSITION
	_component->interface_map ("Two_Level_Branch_Predictor_2","",
				   _name         ,"");
#endif
	
	_component->port_map(name_component, "in_CLOCK" , _name,"in_CLOCK" );
	_component->port_map(name_component, "in_NRESET", _name,"in_NRESET");

    for (uint32_t i=0; i<_param._nb_prediction; i++)
      {
#ifdef POSITION
	_component->interface_map ("Two_Level_Branch_Predictor_2","predict_"+toString(i),
				   _name         ,"predict_"+toString(i));
#endif

	_component->port_map(name_component, "in_PREDICT_"+toString(i)+"_VAL"         , _name, "in_PREDICT_"+toString(i)+"_VAL");
	_component->port_map(name_component,"out_PREDICT_"+toString(i)+"_ACK"         , _name+"_Meta_Predictor_Glue", "in_PREDICT_"+toString(i)+"_PREDICTOR_2_ACK");
	_component->port_map(name_component, "in_PREDICT_"+toString(i)+"_ADDRESS"     , _name, "in_PREDICT_"+toString(i)+"_ADDRESS");
	if (_param._predictor_2_have_bht)					       				       
	_component->port_map(name_component,"out_PREDICT_"+toString(i)+"_BHT_HISTORY" , _name+"_Meta_Predictor_Glue", "in_PREDICT_"+toString(i)+"_PREDICTOR_2_BHT_HISTORY");
	if (_param._predictor_2_have_pht)
	_component->port_map(name_component,"out_PREDICT_"+toString(i)+"_PHT_HISTORY" , _name+"_Meta_Predictor_Glue", "in_PREDICT_"+toString(i)+"_PREDICTOR_2_PHT_HISTORY");
      }
    
    for (uint32_t i=0; i<_param._nb_branch_complete; i++)
      {
#ifdef POSITION
	_component->interface_map ("Two_Level_Branch_Predictor_2","branch_complete_"+toString(i),
				   _name         ,"branch_complete_"+toString(i));
#endif
	if (_param._have_meta_predictor)
	_component->port_map(name_component, "in_BRANCH_COMPLETE_"+toString(i)+"_VAL"         , _name+"_Meta_Predictor_Glue","out_BRANCH_COMPLETE_"+toString(i)+"_PREDICTOR_2_VAL"         );
	else
	_component->port_map(name_component, "in_BRANCH_COMPLETE_"+toString(i)+"_VAL"         , _name, "in_BRANCH_COMPLETE_"+toString(i)+"_VAL"                     );
	_component->port_map(name_component,"out_BRANCH_COMPLETE_"+toString(i)+"_ACK"         , _name+"_Meta_Predictor_Glue", "in_BRANCH_COMPLETE_"+toString(i)+"_PREDICTOR_2_ACK"         );
	_component->port_map(name_component, "in_BRANCH_COMPLETE_"+toString(i)+"_ADDRESS"     , _name, "in_BRANCH_COMPLETE_"+toString(i)+"_ADDRESS"                 );
	if (_param._predictor_2_have_bht)						       					
	_component->port_map(name_component, "in_BRANCH_COMPLETE_"+toString(i)+"_BHT_HISTORY" , _name+"_Meta_Predictor_Glue","out_BRANCH_COMPLETE_"+toString(i)+"_PREDICTOR_2_BHT_HISTORY" );
	if (_param._predictor_2_have_pht)						       					
	_component->port_map(name_component, "in_BRANCH_COMPLETE_"+toString(i)+"_PHT_HISTORY" , _name+"_Meta_Predictor_Glue","out_BRANCH_COMPLETE_"+toString(i)+"_PREDICTOR_2_PHT_HISTORY" );
	if (_param._have_meta_predictor)
	_component->port_map(name_component, "in_BRANCH_COMPLETE_"+toString(i)+"_DIRECTION"   , _name+"_Meta_Predictor_Glue","out_BRANCH_COMPLETE_"+toString(i)+"_PREDICTOR_2_DIRECTION"   );
	else
	_component->port_map(name_component, "in_BRANCH_COMPLETE_"+toString(i)+"_DIRECTION"   , _name, "in_BRANCH_COMPLETE_"+toString(i)+"_DIRECTION"               );	 
      }

    if (_param._have_meta_predictor)
      {
    // =====[component_Two_Level_Branch_Predictor_1 - Instanciation ]====

    name_component = _name+"_Two_Level_Branch_Predictor_1";

    cout << "Instance : " << name_component << endl;

#ifdef POSITION
	_component->interface_map ("Two_Level_Branch_Predictor_1","",
				   _name         ,"");
#endif
	
	_component->port_map(name_component, "in_CLOCK" , _name,"in_CLOCK" );
	_component->port_map(name_component, "in_NRESET", _name,"in_NRESET");

    for (uint32_t i=0; i<_param._nb_prediction; i++)
      {
#ifdef POSITION
	_component->interface_map ("Two_Level_Branch_Predictor_1","predict_"+toString(i),
				   _name         ,"predict_"+toString(i));
#endif

	_component->port_map(name_component, "in_PREDICT_"+toString(i)+"_VAL"         , _name, "in_PREDICT_"+toString(i)+"_VAL");
	_component->port_map(name_component,"out_PREDICT_"+toString(i)+"_ACK"         , _name+"_Meta_Predictor_Glue", "in_PREDICT_"+toString(i)+"_PREDICTOR_1_ACK");
	_component->port_map(name_component, "in_PREDICT_"+toString(i)+"_ADDRESS"     , _name, "in_PREDICT_"+toString(i)+"_ADDRESS");
	if (_param._predictor_1_have_bht)					       				       
	_component->port_map(name_component,"out_PREDICT_"+toString(i)+"_BHT_HISTORY" , _name+"_Meta_Predictor_Glue", "in_PREDICT_"+toString(i)+"_PREDICTOR_1_BHT_HISTORY");
	if (_param._predictor_1_have_pht)
	_component->port_map(name_component,"out_PREDICT_"+toString(i)+"_PHT_HISTORY" , _name+"_Meta_Predictor_Glue", "in_PREDICT_"+toString(i)+"_PREDICTOR_1_PHT_HISTORY");
      }
    
    for (uint32_t i=0; i<_param._nb_branch_complete; i++)
      {
#ifdef POSITION
	_component->interface_map ("Two_Level_Branch_Predictor_1","branch_complete_"+toString(i),
				   _name         ,"branch_complete_"+toString(i));
#endif
	_component->port_map(name_component, "in_BRANCH_COMPLETE_"+toString(i)+"_VAL"         , _name, "in_BRANCH_COMPLETE_"+toString(i)+"_VAL"                     );
	_component->port_map(name_component,"out_BRANCH_COMPLETE_"+toString(i)+"_ACK"         , _name+"_Meta_Predictor_Glue", "in_BRANCH_COMPLETE_"+toString(i)+"_PREDICTOR_1_ACK"         );
	_component->port_map(name_component, "in_BRANCH_COMPLETE_"+toString(i)+"_ADDRESS"     , _name, "in_BRANCH_COMPLETE_"+toString(i)+"_ADDRESS"                 );
	if (_param._predictor_1_have_bht)						       					
	_component->port_map(name_component, "in_BRANCH_COMPLETE_"+toString(i)+"_BHT_HISTORY" , _name+"_Meta_Predictor_Glue","out_BRANCH_COMPLETE_"+toString(i)+"_PREDICTOR_1_BHT_HISTORY" );
	if (_param._predictor_1_have_pht)						       					
	_component->port_map(name_component, "in_BRANCH_COMPLETE_"+toString(i)+"_PHT_HISTORY" , _name+"_Meta_Predictor_Glue","out_BRANCH_COMPLETE_"+toString(i)+"_PREDICTOR_1_PHT_HISTORY" );
	_component->port_map(name_component, "in_BRANCH_COMPLETE_"+toString(i)+"_DIRECTION"   , _name, "in_BRANCH_COMPLETE_"+toString(i)+"_DIRECTION"               );	 
      }
    // =====[component_Two_Level_Branch_Predictor_0 - Instanciation ]====

    name_component = _name+"_Two_Level_Branch_Predictor_0";

    cout << "Instance : " << name_component << endl;

#ifdef POSITION
	_component->interface_map ("Two_Level_Branch_Predictor_0","",
				   _name         ,"");
#endif
	
	_component->port_map(name_component, "in_CLOCK" , _name,"in_CLOCK" );
	_component->port_map(name_component, "in_NRESET", _name,"in_NRESET");

    for (uint32_t i=0; i<_param._nb_prediction; i++)
      {
#ifdef POSITION
	_component->interface_map ("Two_Level_Branch_Predictor_0","predict_"+toString(i),
				   _name         ,"predict_"+toString(i));
#endif

	_component->port_map(name_component, "in_PREDICT_"+toString(i)+"_VAL"         , _name, "in_PREDICT_"+toString(i)+"_VAL");
	_component->port_map(name_component,"out_PREDICT_"+toString(i)+"_ACK"         , _name+"_Meta_Predictor_Glue", "in_PREDICT_"+toString(i)+"_PREDICTOR_0_ACK");
	_component->port_map(name_component, "in_PREDICT_"+toString(i)+"_ADDRESS"     , _name, "in_PREDICT_"+toString(i)+"_ADDRESS");
	if (_param._predictor_0_have_bht)					       				       
	_component->port_map(name_component,"out_PREDICT_"+toString(i)+"_BHT_HISTORY" , _name+"_Meta_Predictor_Glue", "in_PREDICT_"+toString(i)+"_PREDICTOR_0_BHT_HISTORY");
	if (_param._predictor_0_have_pht)
	_component->port_map(name_component,"out_PREDICT_"+toString(i)+"_PHT_HISTORY" , _name+"_Meta_Predictor_Glue", "in_PREDICT_"+toString(i)+"_PREDICTOR_0_PHT_HISTORY");
      }
    
    for (uint32_t i=0; i<_param._nb_branch_complete; i++)
      {
#ifdef POSITION
	_component->interface_map ("Two_Level_Branch_Predictor_0","branch_complete_"+toString(i),
				   _name         ,"branch_complete_"+toString(i));
#endif
	_component->port_map(name_component, "in_BRANCH_COMPLETE_"+toString(i)+"_VAL"         , _name, "in_BRANCH_COMPLETE_"+toString(i)+"_VAL"                     );
	_component->port_map(name_component,"out_BRANCH_COMPLETE_"+toString(i)+"_ACK"         , _name+"_Meta_Predictor_Glue", "in_BRANCH_COMPLETE_"+toString(i)+"_PREDICTOR_0_ACK"         );
	_component->port_map(name_component, "in_BRANCH_COMPLETE_"+toString(i)+"_ADDRESS"     , _name, "in_BRANCH_COMPLETE_"+toString(i)+"_ADDRESS"                 );
	if (_param._predictor_0_have_bht)						       					
	_component->port_map(name_component, "in_BRANCH_COMPLETE_"+toString(i)+"_BHT_HISTORY" , _name+"_Meta_Predictor_Glue","out_BRANCH_COMPLETE_"+toString(i)+"_PREDICTOR_0_BHT_HISTORY" );
	if (_param._predictor_0_have_pht)						       					
	_component->port_map(name_component, "in_BRANCH_COMPLETE_"+toString(i)+"_PHT_HISTORY" , _name+"_Meta_Predictor_Glue","out_BRANCH_COMPLETE_"+toString(i)+"_PREDICTOR_0_PHT_HISTORY" );
	_component->port_map(name_component, "in_BRANCH_COMPLETE_"+toString(i)+"_DIRECTION"   , _name, "in_BRANCH_COMPLETE_"+toString(i)+"_DIRECTION"               );	 
      }
      }

    log_printf(FUNC,Meta_Predictor,"allocation","End");
  };

}; // end namespace meta_predictor

}; // end namespace core
}; // end namespace multi_front_end
}; // end namespace front_end
}; // end namespace prediction_unit
}; // end namespace direction

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
