#ifdef SYSTEMC
/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Stage_1_Ifetch/Predictor/Meta_Predictor/Meta_Predictor_Glue/include/Meta_Predictor_Glue.h"

namespace morpheo                    {
namespace behavioural {
namespace stage_1_ifetch {
namespace predictor {
namespace meta_predictor {
namespace meta_predictor_glue {


  void Meta_Predictor_Glue::allocation (void)
  {
    string rename;

    log_printf(FUNC,Meta_Predictor_Glue,"allocation","Begin");

#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
    in_CLOCK  = new SC_CLOCK           ("in_CLOCK");
#endif

    // Interface Predict

    if (_param._have_meta_predictor)
      {
     in_PREDICT_PREDICTOR_0_ACK         = new SC_IN (Tcontrol_t)     * [_param._nb_prediction     ];
     in_PREDICT_PREDICTOR_1_ACK         = new SC_IN (Tcontrol_t)     * [_param._nb_prediction     ];
      }			           
     in_PREDICT_PREDICTOR_2_ACK         = new SC_IN (Tcontrol_t)     * [_param._nb_prediction     ];
    out_PREDICT_ACK                     = new SC_OUT(Tcontrol_t)     * [_param._nb_prediction     ];
    if (_param._have_meta_predictor)
      {
    if (_param._predictor_0_have_bht)
     in_PREDICT_PREDICTOR_0_BHT_HISTORY = new SC_IN (Tbht_history_t) * [_param._nb_prediction     ];
    if (_param._predictor_0_have_pht)
     in_PREDICT_PREDICTOR_0_PHT_HISTORY = new SC_IN (Tpht_history_t) * [_param._nb_prediction     ];
    if (_param._predictor_1_have_bht)
     in_PREDICT_PREDICTOR_1_BHT_HISTORY = new SC_IN (Tbht_history_t) * [_param._nb_prediction     ];
    if (_param._predictor_1_have_pht)
     in_PREDICT_PREDICTOR_1_PHT_HISTORY = new SC_IN (Tpht_history_t) * [_param._nb_prediction     ];
      }
    if (_param._predictor_2_have_bht)
     in_PREDICT_PREDICTOR_2_BHT_HISTORY = new SC_IN (Tbht_history_t) * [_param._nb_prediction     ];
    if (_param._predictor_2_have_pht)
     in_PREDICT_PREDICTOR_2_PHT_HISTORY = new SC_IN (Tpht_history_t) * [_param._nb_prediction     ];
    out_PREDICT_HISTORY                 = new SC_OUT(Thistory_t)     * [_param._nb_prediction     ];
    out_PREDICT_DIRECTION               = new SC_OUT(Tcontrol_t)     * [_param._nb_prediction     ];

    for (uint32_t i=0; i<_param._nb_prediction; i++)
      {
	if (_param._have_meta_predictor)
	  {
	rename = " in_PREDICT_PREDICTOR_0_ACK_"          +toString(i);
	 in_PREDICT_PREDICTOR_0_ACK                   [i] = new SC_IN (Tcontrol_t)     (rename.c_str());
	
	rename = " in_PREDICT_PREDICTOR_1_ACK_"          +toString(i);
	 in_PREDICT_PREDICTOR_1_ACK                   [i] = new SC_IN (Tcontrol_t)     (rename.c_str());
	  }
	rename = " in_PREDICT_PREDICTOR_2_ACK_"          +toString(i);
	 in_PREDICT_PREDICTOR_2_ACK                   [i] = new SC_IN (Tcontrol_t)     (rename.c_str());
	
	rename = "out_PREDICT_ACK_"                    +toString(i);
	out_PREDICT_ACK                               [i] = new SC_OUT(Tcontrol_t)     (rename.c_str());

	if (_param._have_meta_predictor)
	  {
	if (_param._predictor_0_have_bht)
	  {
	rename = " in_PREDICT_PREDICTOR_0_BHT_HISTORY_"+toString(i);
	 in_PREDICT_PREDICTOR_0_BHT_HISTORY           [i] = new SC_IN (Tbht_history_t) (rename.c_str());
	  }
	if (_param._predictor_0_have_pht)
	  {
	rename = " in_PREDICT_PREDICTOR_0_PHT_HISTORY_"+toString(i);
	 in_PREDICT_PREDICTOR_0_PHT_HISTORY           [i] = new SC_IN (Tpht_history_t) (rename.c_str());
	  }
	if (_param._predictor_1_have_bht)
	  {
	rename = " in_PREDICT_PREDICTOR_1_BHT_HISTORY_"+toString(i);
	 in_PREDICT_PREDICTOR_1_BHT_HISTORY           [i] = new SC_IN (Tbht_history_t) (rename.c_str());
	  }
	if (_param._predictor_1_have_pht)
	  {
	rename = " in_PREDICT_PREDICTOR_1_PHT_HISTORY_"+toString(i);
	 in_PREDICT_PREDICTOR_1_PHT_HISTORY           [i] = new SC_IN (Tpht_history_t) (rename.c_str());
	  }
	  }
	if (_param._predictor_2_have_bht)
	  {
	rename = " in_PREDICT_PREDICTOR_2_BHT_HISTORY_"+toString(i);
	 in_PREDICT_PREDICTOR_2_BHT_HISTORY           [i] = new SC_IN (Tbht_history_t) (rename.c_str());
	  }
	if (_param._predictor_2_have_pht)
	  {
	rename = " in_PREDICT_PREDICTOR_2_PHT_HISTORY_"+toString(i);
	 in_PREDICT_PREDICTOR_2_PHT_HISTORY           [i] = new SC_IN (Tpht_history_t) (rename.c_str());
	  }
	rename = "out_PREDICT_HISTORY_"                +toString(i);
	out_PREDICT_HISTORY                           [i] = new SC_OUT(Thistory_t)     (rename.c_str());

    	rename = "out_PREDICT_DIRECTION_"              +toString(i);
	out_PREDICT_DIRECTION                         [i] = new SC_OUT(Tcontrol_t)     (rename.c_str());
      }

    // Interface Branch_complete
    
    if (_param._have_meta_predictor)
      {
     in_BRANCH_COMPLETE_PREDICTOR_0_ACK         = new SC_IN (Tcontrol_t)     * [_param._nb_branch_complete     ];
     in_BRANCH_COMPLETE_PREDICTOR_1_ACK         = new SC_IN (Tcontrol_t)     * [_param._nb_branch_complete     ];
      }			           
     in_BRANCH_COMPLETE_PREDICTOR_2_ACK         = new SC_IN (Tcontrol_t)     * [_param._nb_branch_complete     ];
    out_BRANCH_COMPLETE_ACK                     = new SC_OUT(Tcontrol_t)     * [_param._nb_branch_complete     ];
    if (_param._have_meta_predictor)
      {
    if (_param._predictor_0_have_bht)
    out_BRANCH_COMPLETE_PREDICTOR_0_BHT_HISTORY = new SC_OUT(Tbht_history_t) * [_param._nb_branch_complete     ];
    if (_param._predictor_0_have_pht)
    out_BRANCH_COMPLETE_PREDICTOR_0_PHT_HISTORY = new SC_OUT(Tpht_history_t) * [_param._nb_branch_complete     ];
    if (_param._predictor_1_have_bht)
    out_BRANCH_COMPLETE_PREDICTOR_1_BHT_HISTORY = new SC_OUT(Tbht_history_t) * [_param._nb_branch_complete     ];
    if (_param._predictor_1_have_pht)
    out_BRANCH_COMPLETE_PREDICTOR_1_PHT_HISTORY = new SC_OUT(Tpht_history_t) * [_param._nb_branch_complete     ];
      }
    if (_param._predictor_2_have_bht)
    out_BRANCH_COMPLETE_PREDICTOR_2_BHT_HISTORY = new SC_OUT(Tbht_history_t) * [_param._nb_branch_complete     ];
    if (_param._predictor_2_have_pht)
    out_BRANCH_COMPLETE_PREDICTOR_2_PHT_HISTORY = new SC_OUT(Tpht_history_t) * [_param._nb_branch_complete     ];
     in_BRANCH_COMPLETE_HISTORY                 = new SC_IN (Thistory_t)     * [_param._nb_branch_complete     ];

    for (uint32_t i=0; i<_param._nb_branch_complete; i++)
      {
	if (_param._have_meta_predictor)
	  {
	rename = " in_BRANCH_COMPLETE_PREDICTOR_0_ACK_"          +toString(i);
	 in_BRANCH_COMPLETE_PREDICTOR_0_ACK                   [i] = new SC_IN (Tcontrol_t)     (rename.c_str());
	
	rename = " in_BRANCH_COMPLETE_PREDICTOR_1_ACK_"          +toString(i);
	 in_BRANCH_COMPLETE_PREDICTOR_1_ACK                   [i] = new SC_IN (Tcontrol_t)     (rename.c_str());
	  }
	rename = " in_BRANCH_COMPLETE_PREDICTOR_2_ACK_"          +toString(i);
	 in_BRANCH_COMPLETE_PREDICTOR_2_ACK                   [i] = new SC_IN (Tcontrol_t)     (rename.c_str());
	
	rename = "out_BRANCH_COMPLETE_ACK_"                    +toString(i);
	out_BRANCH_COMPLETE_ACK                               [i] = new SC_OUT(Tcontrol_t)     (rename.c_str());

	if (_param._have_meta_predictor)
	  {
	if (_param._predictor_0_have_bht)
	  {
	rename = "out_BRANCH_COMPLETE_PREDICTOR_0_BHT_HISTORY_"+toString(i);
	out_BRANCH_COMPLETE_PREDICTOR_0_BHT_HISTORY           [i] = new SC_OUT(Tbht_history_t) (rename.c_str());
	  }
	if (_param._predictor_0_have_pht)
	  {
	rename = "out_BRANCH_COMPLETE_PREDICTOR_0_PHT_HISTORY_"+toString(i);
	out_BRANCH_COMPLETE_PREDICTOR_0_PHT_HISTORY           [i] = new SC_OUT(Tpht_history_t) (rename.c_str());
	  }
	if (_param._predictor_1_have_bht)
	  {
	rename = "out_BRANCH_COMPLETE_PREDICTOR_1_BHT_HISTORY_"+toString(i);
	out_BRANCH_COMPLETE_PREDICTOR_1_BHT_HISTORY           [i] = new SC_OUT(Tbht_history_t) (rename.c_str());
	  }
	if (_param._predictor_1_have_pht)
	  {
	rename = "out_BRANCH_COMPLETE_PREDICTOR_1_PHT_HISTORY_"+toString(i);
	out_BRANCH_COMPLETE_PREDICTOR_1_PHT_HISTORY           [i] = new SC_OUT(Tpht_history_t) (rename.c_str());
	  }
	  }
	if (_param._predictor_2_have_bht)
	  {
	rename = "out_BRANCH_COMPLETE_PREDICTOR_2_BHT_HISTORY_"+toString(i);
	out_BRANCH_COMPLETE_PREDICTOR_2_BHT_HISTORY           [i] = new SC_OUT(Tbht_history_t) (rename.c_str());
	  }
	if (_param._predictor_2_have_pht)
	  {
	rename = "out_BRANCH_COMPLETE_PREDICTOR_2_PHT_HISTORY_"+toString(i);
	out_BRANCH_COMPLETE_PREDICTOR_2_PHT_HISTORY           [i] = new SC_OUT(Tpht_history_t) (rename.c_str());
	  }
	rename = " in_BRANCH_COMPLETE_HISTORY_"                +toString(i);
	 in_BRANCH_COMPLETE_HISTORY                           [i] = new SC_IN (Thistory_t)     (rename.c_str());
      }

    // ~~~~~[Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    log_printf(FUNC,Meta_Predictor_Glue,"allocation","End");
  };

}; // end namespace meta_predictor_glue
}; // end namespace meta_predictor
}; // end namespace predictor
}; // end namespace stage_1_ifetch

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
