#ifdef VHDL
/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Stage_1_Ifetch/Predictor/Meta_Predictor/Meta_Predictor_Glue/include/Meta_Predictor_Glue.h"

namespace morpheo                    {
namespace behavioural {
namespace stage_1_ifetch {
namespace predictor {
namespace meta_predictor {
namespace meta_predictor_glue {


  void Meta_Predictor_Glue::vhdl_body (Vhdl & vhdl)
  {
    log_printf(FUNC,Meta_Predictor_Glue,"vhdl_body","Begin");
    vhdl.set_body ("");
    vhdl.set_body (" -- predict");
    
    for (uint32_t i=0; i<_param._nb_prediction; i++)
      {
	string meta_predictor_ack =  (_param._have_meta_predictor==true)?("in_PREDICT_PREDICTOR_0_ACK_"+toString(i)+" and in_PREDICT_PREDICTOR_1_ACK_"+toString(i)):"'1'";

	vhdl.set_body ("out_PREDICT_ACK_"+toString(i)+"         <= "+meta_predictor_ack+" and "+"in_PREDICT_PREDICTOR_2_ACK_"+toString(i)+";");

	uint32_t index=_param._size_history;


	if (_param._predictor_2_have_pht)
	  {
	vhdl.set_body ("out_PREDICT_HISTORY_"+toString(i)+std_logic_range(index-1,index-_param._predictor_2_pht_size_counter)+" <= in_PREDICT_PREDICTOR_2_PHT_HISTORY_"+toString(i)+";");
	index-= _param._predictor_2_pht_size_counter;
	  }
	if (_param._predictor_2_have_bht)
	  {
	vhdl.set_body ("out_PREDICT_HISTORY_"+toString(i)+std_logic_range(index-1,index-_param._predictor_2_bht_size_shifter)+" <= in_PREDICT_PREDICTOR_2_BHT_HISTORY_"+toString(i)+";");
	index-= _param._predictor_2_bht_size_shifter;
	  }

	if (_param._have_meta_predictor)
	  {
	if (_param._predictor_1_have_pht)
	  {
	vhdl.set_body ("out_PREDICT_HISTORY_"+toString(i)+std_logic_range(index-1,index-_param._predictor_1_pht_size_counter)+" <= in_PREDICT_PREDICTOR_1_PHT_HISTORY_"+toString(i)+";");
	index-= _param._predictor_1_pht_size_counter;
	  }
	if (_param._predictor_1_have_bht)
	  {
	vhdl.set_body ("out_PREDICT_HISTORY_"+toString(i)+std_logic_range(index-1,index-_param._predictor_1_bht_size_shifter)+" <= in_PREDICT_PREDICTOR_1_BHT_HISTORY_"+toString(i)+";");
	index-= _param._predictor_1_bht_size_shifter;
	  }

 	if (_param._predictor_0_have_pht)
	  {
	vhdl.set_body ("out_PREDICT_HISTORY_"+toString(i)+std_logic_range(index-1,index-_param._predictor_0_pht_size_counter)+" <= in_PREDICT_PREDICTOR_0_PHT_HISTORY_"+toString(i)+";");
	index-= _param._predictor_0_pht_size_counter;
	  }
	if (_param._predictor_0_have_bht)
	  {
	vhdl.set_body ("out_PREDICT_HISTORY_"+toString(i)+std_logic_range(index-1,index-_param._predictor_0_bht_size_shifter)+" <= in_PREDICT_PREDICTOR_0_BHT_HISTORY_"+toString(i)+";");
	index-= _param._predictor_0_bht_size_shifter;
	  }
	  }

	// direction of prediction
	vhdl.set_body ("");
	if (_param._have_meta_predictor)
	  vhdl.set_body ("out_PREDICT_DIRECTION_"+toString(i)+"   <= predictor_0_direction_"+toString(i)+" when predictor_2_direction_"+toString(i)+"='0' else predictor_1_direction_"+toString(i)+";");
	else
	  vhdl.set_body ("out_PREDICT_DIRECTION_"+toString(i)+"   <= predictor_2_direction_"+toString(i)+";");
      }

    // Interface - branch_complete

    vhdl.set_body ("");
    vhdl.set_body (" -- branch_complete");
    for (uint32_t i=0; i<_param._nb_branch_complete; i++)
      {
	string meta_predictor_ack =  (_param._have_meta_predictor==true)?("in_BRANCH_COMPLETE_PREDICTOR_0_ACK_"+toString(i)+" and in_BRANCH_COMPLETE_PREDICTOR_1_ACK_"+toString(i)):"'1'";

	vhdl.set_body ("out_BRANCH_COMPLETE_ACK_"+toString(i)+" <= "+meta_predictor_ack+" and "+"in_BRANCH_COMPLETE_PREDICTOR_2_ACK_"+toString(i)+";");

	uint32_t index=_param._size_history;

	if (_param._predictor_2_have_pht)
	  {
	vhdl.set_body ("out_BRANCH_COMPLETE_PREDICTOR_2_PHT_HISTORY_"+toString(i)+" <= in_BRANCH_COMPLETE_HISTORY_"+toString(i)+std_logic_range(index-1,index-_param._predictor_2_pht_size_counter)+";");
	index-= _param._predictor_2_pht_size_counter;
	  }
	if (_param._predictor_2_have_bht)
	  {
	vhdl.set_body ("out_BRANCH_COMPLETE_PREDICTOR_2_BHT_HISTORY_"+toString(i)+" <= in_BRANCH_COMPLETE_HISTORY_"+toString(i)+std_logic_range(index-1,index-_param._predictor_2_bht_size_shifter)+";");
	index-= _param._predictor_2_bht_size_shifter;
	  }

	if (_param._have_meta_predictor)
	  {
	if (_param._predictor_1_have_pht)
	  {
	vhdl.set_body ("out_BRANCH_COMPLETE_PREDICTOR_1_PHT_HISTORY_"+toString(i)+" <= in_BRANCH_COMPLETE_HISTORY_"+toString(i)+std_logic_range(index-1,index-_param._predictor_1_pht_size_counter)+";");
	index-= _param._predictor_1_pht_size_counter;
	  }
	if (_param._predictor_1_have_bht)
	  {
	vhdl.set_body ("out_BRANCH_COMPLETE_PREDICTOR_1_BHT_HISTORY_"+toString(i)+" <= in_BRANCH_COMPLETE_HISTORY_"+toString(i)+std_logic_range(index-1,index-_param._predictor_1_bht_size_shifter)+";");
	index-= _param._predictor_1_bht_size_shifter;
	  }

	if (_param._predictor_0_have_pht)
	  {
	vhdl.set_body ("out_BRANCH_COMPLETE_PREDICTOR_0_PHT_HISTORY_"+toString(i)+" <= in_BRANCH_COMPLETE_HISTORY_"+toString(i)+std_logic_range(index-1,index-_param._predictor_0_pht_size_counter)+";");
	index-= _param._predictor_0_pht_size_counter;
	  }
	if (_param._predictor_0_have_bht)
	  {
	vhdl.set_body ("out_BRANCH_COMPLETE_PREDICTOR_0_BHT_HISTORY_"+toString(i)+" <= in_BRANCH_COMPLETE_HISTORY_"+toString(i)+std_logic_range(index-1,index-_param._predictor_0_bht_size_shifter)+";");
	index-= _param._predictor_0_bht_size_shifter;
	  }
	  }
      }

    log_printf(FUNC,Meta_Predictor_Glue,"vhdl_body","End");
  };

}; // end namespace meta_predictor_glue
}; // end namespace meta_predictor
}; // end namespace predictor
}; // end namespace stage_1_ifetch

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
