/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Stage_1_Ifetch/Predictor/Meta_Predictor/include/Meta_Predictor.h"

namespace morpheo                    {
namespace behavioural {
namespace stage_1_ifetch {
namespace predictor {
namespace meta_predictor {


#ifdef SYSTEMC
  Meta_Predictor::Meta_Predictor (sc_module_name name,
#else
  Meta_Predictor::Meta_Predictor (string name,
#endif
#ifdef STATISTICS
			      morpheo::behavioural::Parameters_Statistics             param_statistics,
#endif
			      morpheo::behavioural::stage_1_ifetch::predictor::meta_predictor::Parameters param ):
			      _name              (name)
			      ,_param            (param)
#ifdef STATISTICS
			      ,_param_statistics (param_statistics)
#endif
  {
    log_printf(FUNC,Meta_Predictor,"Meta_Predictor","Begin");

#ifdef STATISTICS
    // Allocation of statistics
    _stat = new Statistics (static_cast<string>(_name),
			    param_statistics          ,
			    param);
#endif

#ifdef VHDL_TESTBENCH
    // Creation of a testbench
    //  -> port
    //  -> clock's signals
    _vhdl_testbench = new Vhdl_Testbench (_name);
    vhdl_testbench_port           ();
    _vhdl_testbench->set_clock    ("in_CLOCK",true);
#endif

#ifdef VHDL
    // generate the vhdl
    vhdl();
#endif

#ifdef SYSTEMC
    allocation ();

#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
    SC_METHOD (transition);
    dont_initialize ();
    sensitive_pos << *(in_CLOCK);
#endif

#ifdef SYSTEMCASS_SPECIFIC
    // List dependency information
#endif    

#endif
    log_printf(FUNC,Meta_Predictor,"Meta_Predictor","End");
  };
  
  Meta_Predictor::~Meta_Predictor (void)
  {
    log_printf(FUNC,Meta_Predictor,"~Meta_Predictor","Begin");

#ifdef VHDL_TESTBENCH
    // generate the test bench
    _vhdl_testbench->generate_file();
    delete _vhdl_testbench;
#endif

#ifdef STATISTICS
    _stat->generate_file(statistics(0));
    
    delete _stat;
#endif

#ifdef SYSTEMC
    deallocation ();
#endif

    log_printf(FUNC,Meta_Predictor,"~Meta_Predictor","End");
  };

}; // end namespace meta_predictor
}; // end namespace predictor
}; // end namespace stage_1_ifetch

}; // end namespace behavioural
}; // end namespace morpheo              
