#ifdef SYSTEMC
/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Stage_1_Ifetch/Predictor/Meta_Predictor/include/Meta_Predictor.h"

namespace morpheo                    {
namespace behavioural {
namespace stage_1_ifetch {
namespace predictor {
namespace meta_predictor {


  void Meta_Predictor::allocation (void)
  {
    string rename;

    log_printf(FUNC,Meta_Predictor,"allocation","Begin");

    in_CLOCK  = new SC_CLOCK           ("in_CLOCK");

     in_PREDICT_VAL                 = new SC_IN (Tcontrol_t)     * [_param._nb_prediction     ];
    out_PREDICT_ACK                 = new SC_OUT(Tcontrol_t)     * [_param._nb_prediction     ];
     in_PREDICT_ADDRESS             = new SC_IN (Taddress_t)     * [_param._nb_prediction     ];
    out_PREDICT_HISTORY             = new SC_OUT(Thistory_t)     * [_param._nb_prediction     ];
    out_PREDICT_DIRECTION           = new SC_OUT(Tcontrol_t)     * [_param._nb_prediction     ];

    for (uint32_t i=0; i<_param._nb_prediction; i++)
      {
	rename = "in_PREDICT_VAL_"         +toString(i);
	 in_PREDICT_VAL                 [i] = new SC_IN (Tcontrol_t)     (rename.c_str());

	rename = "out_PREDICT_ACK_"        +toString(i);
	out_PREDICT_ACK                 [i] = new SC_OUT(Tcontrol_t)     (rename.c_str());

	rename = "in_PREDICT_ADDRESS_"     +toString(i);
	 in_PREDICT_ADDRESS             [i] = new SC_IN (Taddress_t)     (rename.c_str());

	rename = "out_PREDICT_HISTORY_"    +toString(i);
	out_PREDICT_HISTORY             [i] = new SC_OUT(Thistory_t)     (rename.c_str());

    	rename = "out_PREDICT_DIRECTION_"  +toString(i);
	out_PREDICT_DIRECTION           [i] = new SC_OUT(Tcontrol_t)     (rename.c_str());
      }

     in_BRANCH_COMPLETE_VAL         = new SC_IN (Tcontrol_t)     * [_param._nb_branch_complete];
    out_BRANCH_COMPLETE_ACK         = new SC_OUT(Tcontrol_t)     * [_param._nb_branch_complete];
     in_BRANCH_COMPLETE_ADDRESS     = new SC_IN (Taddress_t)     * [_param._nb_branch_complete];
     in_BRANCH_COMPLETE_HISTORY     = new SC_IN (Thistory_t)     * [_param._nb_branch_complete];
     in_BRANCH_COMPLETE_DIRECTION   = new SC_IN (Tcontrol_t)     * [_param._nb_branch_complete];

    for (uint32_t i=0; i<_param._nb_branch_complete; i++)
      {
	rename = "in_BRANCH_COMPLETE_VAL_"         +toString(i);
	 in_BRANCH_COMPLETE_VAL         [i] = new SC_IN (Tcontrol_t)     (rename.c_str());

	rename = "out_BRANCH_COMPLETE_ACK_"        +toString(i);
	out_BRANCH_COMPLETE_ACK         [i] = new SC_OUT(Tcontrol_t)     (rename.c_str());

	rename = "in_BRANCH_COMPLETE_ADDRESS_"     +toString(i);
	 in_BRANCH_COMPLETE_ADDRESS     [i] = new SC_IN (Taddress_t)     (rename.c_str());

    	rename = "in_BRANCH_COMPLETE_HISTORY_"     +toString(i);
	 in_BRANCH_COMPLETE_HISTORY     [i] = new SC_IN (Thistory_t)     (rename.c_str());

	rename = "in_BRANCH_COMPLETE_DIRECTION_"   +toString(i);
	 in_BRANCH_COMPLETE_DIRECTION   [i] = new SC_IN (Tcontrol_t)     (rename.c_str());
      }

    // ~~~~~[Signal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

    if (_param._have_meta_predictor)
      {
    signal_PREDICT_PREDICTOR_0_ACK         = new SC_SIGNAL(Tcontrol_t) * [_param._nb_prediction];
    signal_PREDICT_PREDICTOR_1_ACK         = new SC_SIGNAL(Tcontrol_t) * [_param._nb_prediction];
      }
    signal_PREDICT_PREDICTOR_2_ACK         = new SC_SIGNAL(Tcontrol_t) * [_param._nb_prediction];

    if (_param._have_meta_predictor)
      {									      					      
    if (_param._predictor_0_have_bht)
    signal_PREDICT_PREDICTOR_0_BHT_HISTORY = new SC_SIGNAL(morpheo::behavioural::stage_1_ifetch::predictor::meta_predictor::two_level_branch_predictor::Tbht_history_t) * [_param._nb_prediction];
    if (_param._predictor_0_have_pht)
    signal_PREDICT_PREDICTOR_0_PHT_HISTORY = new SC_SIGNAL(morpheo::behavioural::stage_1_ifetch::predictor::meta_predictor::two_level_branch_predictor::Tpht_history_t) * [_param._nb_prediction];
    if (_param._predictor_0_have_bht)
    signal_PREDICT_PREDICTOR_1_BHT_HISTORY = new SC_SIGNAL(morpheo::behavioural::stage_1_ifetch::predictor::meta_predictor::two_level_branch_predictor::Tbht_history_t) * [_param._nb_prediction];
    if (_param._predictor_1_have_pht)
    signal_PREDICT_PREDICTOR_1_PHT_HISTORY = new SC_SIGNAL(morpheo::behavioural::stage_1_ifetch::predictor::meta_predictor::two_level_branch_predictor::Tpht_history_t) * [_param._nb_prediction];
      }									      					      
    if (_param._predictor_2_have_bht)
    signal_PREDICT_PREDICTOR_2_BHT_HISTORY = new SC_SIGNAL(morpheo::behavioural::stage_1_ifetch::predictor::meta_predictor::two_level_branch_predictor::Tbht_history_t) * [_param._nb_prediction];
    if (_param._predictor_2_have_pht)
    signal_PREDICT_PREDICTOR_2_PHT_HISTORY = new SC_SIGNAL(morpheo::behavioural::stage_1_ifetch::predictor::meta_predictor::two_level_branch_predictor::Tpht_history_t) * [_param._nb_prediction];

    for (uint32_t i=0; i<_param._nb_prediction; i++)
      {
	if (_param._have_meta_predictor)
	  {									      					      
	rename = "signal_PREDICT_PREDICTOR_0_ACK_"+toString(i);
	signal_PREDICT_PREDICTOR_0_ACK         [i] = new SC_SIGNAL(Tcontrol_t) (rename.c_str());
	rename = "signal_PREDICT_PREDICTOR_1_ACK_"+toString(i);
	signal_PREDICT_PREDICTOR_1_ACK         [i] = new SC_SIGNAL(Tcontrol_t) (rename.c_str());
	  }
	rename = "signal_PREDICT_PREDICTOR_2_ACK_"+toString(i);
	signal_PREDICT_PREDICTOR_2_ACK         [i] = new SC_SIGNAL(Tcontrol_t) (rename.c_str());

	if (_param._have_meta_predictor)
	  {									      					      
	if (_param._predictor_0_have_bht)
	  {
	rename = "signal_PREDICT_PREDICTOR_0_BHT_HISTORY_"+toString(i);
	signal_PREDICT_PREDICTOR_0_BHT_HISTORY [i] = new SC_SIGNAL(morpheo::behavioural::stage_1_ifetch::predictor::meta_predictor::two_level_branch_predictor::Tbht_history_t)  (rename.c_str());
	  }
	if (_param._predictor_0_have_pht)
	  {
	rename = "signal_PREDICT_PREDICTOR_0_PHT_HISTORY_"+toString(i);
	signal_PREDICT_PREDICTOR_0_PHT_HISTORY [i] = new SC_SIGNAL(morpheo::behavioural::stage_1_ifetch::predictor::meta_predictor::two_level_branch_predictor::Tpht_history_t)  (rename.c_str());
	  }
	if (_param._predictor_1_have_bht)
	  {
	rename = "signal_PREDICT_PREDICTOR_1_BHT_HISTORY_"+toString(i);
	signal_PREDICT_PREDICTOR_1_BHT_HISTORY [i] = new SC_SIGNAL(morpheo::behavioural::stage_1_ifetch::predictor::meta_predictor::two_level_branch_predictor::Tbht_history_t)  (rename.c_str());
	  }
	if (_param._predictor_1_have_pht)
	  {
	rename = "signal_PREDICT_PREDICTOR_1_PHT_HISTORY_"+toString(i);
	signal_PREDICT_PREDICTOR_1_PHT_HISTORY [i] = new SC_SIGNAL(morpheo::behavioural::stage_1_ifetch::predictor::meta_predictor::two_level_branch_predictor::Tpht_history_t)  (rename.c_str());
	  }
	  }
	if (_param._predictor_2_have_bht)
	  {
	rename = "signal_PREDICT_PREDICTOR_2_BHT_HISTORY_"+toString(i);
	signal_PREDICT_PREDICTOR_2_BHT_HISTORY [i] = new SC_SIGNAL(morpheo::behavioural::stage_1_ifetch::predictor::meta_predictor::two_level_branch_predictor::Tbht_history_t)  (rename.c_str());
	  }
	if (_param._predictor_2_have_pht)
	  {
	rename = "signal_PREDICT_PREDICTOR_2_PHT_HISTORY_"+toString(i);
	signal_PREDICT_PREDICTOR_2_PHT_HISTORY [i] = new SC_SIGNAL(morpheo::behavioural::stage_1_ifetch::predictor::meta_predictor::two_level_branch_predictor::Tpht_history_t)  (rename.c_str());
	  }
      }
    if (_param._have_meta_predictor)
      {
    signal_BRANCH_COMPLETE_PREDICTOR_0_ACK         = new SC_SIGNAL(Tcontrol_t) * [_param._nb_prediction];
    signal_BRANCH_COMPLETE_PREDICTOR_1_ACK         = new SC_SIGNAL(Tcontrol_t) * [_param._nb_prediction];
    signal_BRANCH_COMPLETE_PREDICTOR_2_VAL         = new SC_SIGNAL(Tcontrol_t) * [_param._nb_prediction];
    signal_BRANCH_COMPLETE_PREDICTOR_2_DIRECTION   = new SC_SIGNAL(Tcontrol_t) * [_param._nb_prediction];
      }
    signal_BRANCH_COMPLETE_PREDICTOR_2_ACK         = new SC_SIGNAL(Tcontrol_t) * [_param._nb_prediction];

    if (_param._have_meta_predictor)
      {									      					      
    if (_param._predictor_0_have_bht)
    signal_BRANCH_COMPLETE_PREDICTOR_0_BHT_HISTORY = new SC_SIGNAL(morpheo::behavioural::stage_1_ifetch::predictor::meta_predictor::two_level_branch_predictor::Tbht_history_t) * [_param._nb_prediction];
    if (_param._predictor_0_have_pht)
    signal_BRANCH_COMPLETE_PREDICTOR_0_PHT_HISTORY = new SC_SIGNAL(morpheo::behavioural::stage_1_ifetch::predictor::meta_predictor::two_level_branch_predictor::Tpht_history_t) * [_param._nb_prediction];
    if (_param._predictor_0_have_bht)
    signal_BRANCH_COMPLETE_PREDICTOR_1_BHT_HISTORY = new SC_SIGNAL(morpheo::behavioural::stage_1_ifetch::predictor::meta_predictor::two_level_branch_predictor::Tbht_history_t) * [_param._nb_prediction];
    if (_param._predictor_1_have_pht)
    signal_BRANCH_COMPLETE_PREDICTOR_1_PHT_HISTORY = new SC_SIGNAL(morpheo::behavioural::stage_1_ifetch::predictor::meta_predictor::two_level_branch_predictor::Tpht_history_t) * [_param._nb_prediction];
      }									      					      
    if (_param._predictor_2_have_bht)
    signal_BRANCH_COMPLETE_PREDICTOR_2_BHT_HISTORY = new SC_SIGNAL(morpheo::behavioural::stage_1_ifetch::predictor::meta_predictor::two_level_branch_predictor::Tbht_history_t) * [_param._nb_prediction];
    if (_param._predictor_2_have_pht)
    signal_BRANCH_COMPLETE_PREDICTOR_2_PHT_HISTORY = new SC_SIGNAL(morpheo::behavioural::stage_1_ifetch::predictor::meta_predictor::two_level_branch_predictor::Tpht_history_t) * [_param._nb_prediction];

    for (uint32_t i=0; i<_param._nb_branch_complete; i++)
      {
	if (_param._have_meta_predictor)
	  {									      					      
	rename = "signal_BRANCH_COMPLETE_PREDICTOR_0_ACK_"+toString(i);
	signal_BRANCH_COMPLETE_PREDICTOR_0_ACK         [i] = new SC_SIGNAL(Tcontrol_t) (rename.c_str());
	rename = "signal_BRANCH_COMPLETE_PREDICTOR_1_ACK_"+toString(i);
	signal_BRANCH_COMPLETE_PREDICTOR_1_ACK         [i] = new SC_SIGNAL(Tcontrol_t) (rename.c_str());
	rename = "signal_BRANCH_COMPLETE_PREDICTOR_2_VAL_"+toString(i);
	signal_BRANCH_COMPLETE_PREDICTOR_2_VAL         [i] = new SC_SIGNAL(Tcontrol_t) (rename.c_str());
	rename = "signal_BRANCH_COMPLETE_PREDICTOR_2_DIRECTION_"+toString(i);
	signal_BRANCH_COMPLETE_PREDICTOR_2_DIRECTION   [i] = new SC_SIGNAL(Tcontrol_t) (rename.c_str());
	  }
	rename = "signal_BRANCH_COMPLETE_PREDICTOR_2_ACK_"+toString(i);
	signal_BRANCH_COMPLETE_PREDICTOR_2_ACK         [i] = new SC_SIGNAL(Tcontrol_t) (rename.c_str());

	if (_param._have_meta_predictor)
	  {									      					      
	if (_param._predictor_0_have_bht)
	  {
	rename = "signal_BRANCH_COMPLETE_PREDICTOR_0_BHT_HISTORY_"+toString(i);
	signal_BRANCH_COMPLETE_PREDICTOR_0_BHT_HISTORY [i] = new SC_SIGNAL(morpheo::behavioural::stage_1_ifetch::predictor::meta_predictor::two_level_branch_predictor::Tbht_history_t)  (rename.c_str());
	  }
	if (_param._predictor_0_have_pht)
	  {
	rename = "signal_BRANCH_COMPLETE_PREDICTOR_0_PHT_HISTORY_"+toString(i);
	signal_BRANCH_COMPLETE_PREDICTOR_0_PHT_HISTORY [i] = new SC_SIGNAL(morpheo::behavioural::stage_1_ifetch::predictor::meta_predictor::two_level_branch_predictor::Tpht_history_t)  (rename.c_str());
	  }
	if (_param._predictor_1_have_bht)
	  {
	rename = "signal_BRANCH_COMPLETE_PREDICTOR_1_BHT_HISTORY_"+toString(i);
	signal_BRANCH_COMPLETE_PREDICTOR_1_BHT_HISTORY [i] = new SC_SIGNAL(morpheo::behavioural::stage_1_ifetch::predictor::meta_predictor::two_level_branch_predictor::Tbht_history_t)  (rename.c_str());
	  }
	if (_param._predictor_1_have_pht)
	  {
	rename = "signal_BRANCH_COMPLETE_PREDICTOR_1_PHT_HISTORY_"+toString(i);
	signal_BRANCH_COMPLETE_PREDICTOR_1_PHT_HISTORY [i] = new SC_SIGNAL(morpheo::behavioural::stage_1_ifetch::predictor::meta_predictor::two_level_branch_predictor::Tpht_history_t)  (rename.c_str());
	  }
	  }
	if (_param._predictor_2_have_bht)
	  {
	rename = "signal_BRANCH_COMPLETE_PREDICTOR_2_BHT_HISTORY_"+toString(i);
	signal_BRANCH_COMPLETE_PREDICTOR_2_BHT_HISTORY [i] = new SC_SIGNAL(morpheo::behavioural::stage_1_ifetch::predictor::meta_predictor::two_level_branch_predictor::Tbht_history_t)  (rename.c_str());
	  }
	if (_param._predictor_2_have_pht)
	  {
	rename = "signal_BRANCH_COMPLETE_PREDICTOR_2_PHT_HISTORY_"+toString(i);
	signal_BRANCH_COMPLETE_PREDICTOR_2_PHT_HISTORY [i] = new SC_SIGNAL(morpheo::behavioural::stage_1_ifetch::predictor::meta_predictor::two_level_branch_predictor::Tpht_history_t)  (rename.c_str());
	  }
      }

    // ~~~~~[Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    string name_component;

    // =====[component_Meta_Predictor_Glue ]=============================

    name_component = _name+"_Meta_Predictor_Glue";
    
    log_printf(INFO,Meta_Predictor,"allocation","Allocation : %s",name_component.c_str());
    
    component_Meta_Predictor_Glue = new morpheo::behavioural::stage_1_ifetch::predictor::meta_predictor::meta_predictor_glue::Meta_Predictor_Glue (name_component.c_str()               ,
#ifdef STATISTICS	
																		     _param_statistics                    ,
#endif
																		     *(_param._param_meta_predictor_glue));
    
    // Instantiation
    (*(component_Meta_Predictor_Glue->in_CLOCK))        (*(in_CLOCK));
    
        // Interface Predict
    for (uint32_t i=0; i<_param._nb_prediction; i++)
      {
	if (_param._have_meta_predictor)
	  {
	(*(component_Meta_Predictor_Glue-> in_PREDICT_PREDICTOR_0_ACK                 [i])) (*(signal_PREDICT_PREDICTOR_0_ACK                 [i]));
	(*(component_Meta_Predictor_Glue-> in_PREDICT_PREDICTOR_1_ACK                 [i])) (*(signal_PREDICT_PREDICTOR_1_ACK                 [i]));
	  }									      					      
	(*(component_Meta_Predictor_Glue-> in_PREDICT_PREDICTOR_2_ACK                 [i])) (*(signal_PREDICT_PREDICTOR_2_ACK                 [i]));
	(*(component_Meta_Predictor_Glue->out_PREDICT_ACK                             [i])) (*(   out_PREDICT_ACK                             [i]));
	if (_param._have_meta_predictor)
	  {									      					      
	if (_param._predictor_0_have_bht)
	(*(component_Meta_Predictor_Glue-> in_PREDICT_PREDICTOR_0_BHT_HISTORY         [i])) (*(signal_PREDICT_PREDICTOR_0_BHT_HISTORY         [i]));
	if (_param._predictor_0_have_pht)
	(*(component_Meta_Predictor_Glue-> in_PREDICT_PREDICTOR_0_PHT_HISTORY         [i])) (*(signal_PREDICT_PREDICTOR_0_PHT_HISTORY         [i]));
	if (_param._predictor_1_have_bht)
	(*(component_Meta_Predictor_Glue-> in_PREDICT_PREDICTOR_1_BHT_HISTORY         [i])) (*(signal_PREDICT_PREDICTOR_1_BHT_HISTORY         [i]));
	if (_param._predictor_1_have_pht)
	(*(component_Meta_Predictor_Glue-> in_PREDICT_PREDICTOR_1_PHT_HISTORY         [i])) (*(signal_PREDICT_PREDICTOR_1_PHT_HISTORY         [i]));
	  }									      					      
	if (_param._predictor_2_have_bht)
	(*(component_Meta_Predictor_Glue-> in_PREDICT_PREDICTOR_2_BHT_HISTORY         [i])) (*(signal_PREDICT_PREDICTOR_2_BHT_HISTORY         [i]));
	if (_param._predictor_2_have_pht)
	(*(component_Meta_Predictor_Glue-> in_PREDICT_PREDICTOR_2_PHT_HISTORY         [i])) (*(signal_PREDICT_PREDICTOR_2_PHT_HISTORY         [i]));
	(*(component_Meta_Predictor_Glue->out_PREDICT_HISTORY                         [i])) (*(   out_PREDICT_HISTORY                         [i]));
	(*(component_Meta_Predictor_Glue->out_PREDICT_DIRECTION                       [i])) (*(   out_PREDICT_DIRECTION                       [i]));
      }

    // Interface Branch_complete
    
    for (uint32_t i=0; i<_param._nb_branch_complete; i++)
      {
	if (_param._have_meta_predictor)
	  {
	(*(component_Meta_Predictor_Glue-> in_BRANCH_COMPLETE_VAL                     [i])) (*(    in_BRANCH_COMPLETE_VAL                     [i]));
	(*(component_Meta_Predictor_Glue->out_BRANCH_COMPLETE_PREDICTOR_2_VAL         [i])) (*(signal_BRANCH_COMPLETE_PREDICTOR_2_VAL         [i]));

	(*(component_Meta_Predictor_Glue-> in_BRANCH_COMPLETE_PREDICTOR_0_ACK         [i])) (*(signal_BRANCH_COMPLETE_PREDICTOR_0_ACK         [i]));
	(*(component_Meta_Predictor_Glue-> in_BRANCH_COMPLETE_PREDICTOR_1_ACK         [i])) (*(signal_BRANCH_COMPLETE_PREDICTOR_1_ACK         [i]));
	  }					
	(*(component_Meta_Predictor_Glue-> in_BRANCH_COMPLETE_PREDICTOR_2_ACK         [i])) (*(signal_BRANCH_COMPLETE_PREDICTOR_2_ACK         [i]));
	(*(component_Meta_Predictor_Glue->out_BRANCH_COMPLETE_ACK                     [i])) (*(   out_BRANCH_COMPLETE_ACK                     [i]));
						
	if (_param._have_meta_predictor)	
	  {					
	if (_param._predictor_0_have_bht)
	(*(component_Meta_Predictor_Glue->out_BRANCH_COMPLETE_PREDICTOR_0_BHT_HISTORY [i])) (*(signal_BRANCH_COMPLETE_PREDICTOR_0_BHT_HISTORY [i]));
	if (_param._predictor_0_have_pht)
	(*(component_Meta_Predictor_Glue->out_BRANCH_COMPLETE_PREDICTOR_0_PHT_HISTORY [i])) (*(signal_BRANCH_COMPLETE_PREDICTOR_0_PHT_HISTORY [i]));
	if (_param._predictor_1_have_bht)
	(*(component_Meta_Predictor_Glue->out_BRANCH_COMPLETE_PREDICTOR_1_BHT_HISTORY [i])) (*(signal_BRANCH_COMPLETE_PREDICTOR_1_BHT_HISTORY [i]));
	if (_param._predictor_1_have_pht)
	(*(component_Meta_Predictor_Glue->out_BRANCH_COMPLETE_PREDICTOR_1_PHT_HISTORY [i])) (*(signal_BRANCH_COMPLETE_PREDICTOR_1_PHT_HISTORY [i]));
	  }					
	if (_param._predictor_2_have_bht)
	(*(component_Meta_Predictor_Glue->out_BRANCH_COMPLETE_PREDICTOR_2_BHT_HISTORY [i])) (*(signal_BRANCH_COMPLETE_PREDICTOR_2_BHT_HISTORY [i]));
	if (_param._predictor_2_have_pht)
	(*(component_Meta_Predictor_Glue->out_BRANCH_COMPLETE_PREDICTOR_2_PHT_HISTORY [i])) (*(signal_BRANCH_COMPLETE_PREDICTOR_2_PHT_HISTORY [i]));
	(*(component_Meta_Predictor_Glue-> in_BRANCH_COMPLETE_HISTORY                 [i])) (*(    in_BRANCH_COMPLETE_HISTORY                 [i]));
	if (_param._have_meta_predictor)	
	  {
	(*(component_Meta_Predictor_Glue-> in_BRANCH_COMPLETE_DIRECTION               [i])) (*(    in_BRANCH_COMPLETE_DIRECTION               [i]));
	(*(component_Meta_Predictor_Glue->out_BRANCH_COMPLETE_PREDICTOR_2_DIRECTION   [i])) (*(signal_BRANCH_COMPLETE_PREDICTOR_2_DIRECTION   [i]));
	  }
      }

    // =====[component_Two_Level_Branch_Predictor_2 ]====================    

    name_component = _name+"_Two_Level_Branch_Predictor_2";
    
    log_printf(INFO,Meta_Predictor,"allocation","Allocation : %s",name_component.c_str());
    
    component_Two_Level_Branch_Predictor_2 = new morpheo::behavioural::stage_1_ifetch::predictor::meta_predictor::two_level_branch_predictor ::Two_Level_Branch_Predictor (name_component.c_str()               ,
#ifdef STATISTICS	
																					   _param_statistics                    ,
#endif
																					   *(_param._param_two_level_branch_predictor_2));
      
    // Instantiation
    (*(component_Two_Level_Branch_Predictor_2->in_CLOCK))        (*(in_CLOCK));
    
    for (uint32_t i=0; i<_param._nb_prediction; i++)
      {
	(*(component_Two_Level_Branch_Predictor_2-> in_PREDICT_VAL                 [i])) (*(    in_PREDICT_VAL                             [i]));
	(*(component_Two_Level_Branch_Predictor_2->out_PREDICT_ACK                 [i])) (*(signal_PREDICT_PREDICTOR_2_ACK                 [i]));
	(*(component_Two_Level_Branch_Predictor_2-> in_PREDICT_ADDRESS             [i])) (*(    in_PREDICT_ADDRESS                         [i]));
	if (_param._predictor_2_have_bht)						       				       
	(*(component_Two_Level_Branch_Predictor_2->out_PREDICT_BHT_HISTORY         [i])) (*(signal_PREDICT_PREDICTOR_2_BHT_HISTORY         [i]));
	if (_param._predictor_2_have_pht)
	(*(component_Two_Level_Branch_Predictor_2->out_PREDICT_PHT_HISTORY         [i])) (*(signal_PREDICT_PREDICTOR_2_PHT_HISTORY         [i]));
      }
    
    for (uint32_t i=0; i<_param._nb_branch_complete; i++)
      {
	if (_param._have_meta_predictor)
	(*(component_Two_Level_Branch_Predictor_2-> in_BRANCH_COMPLETE_VAL         [i])) (*(signal_BRANCH_COMPLETE_PREDICTOR_2_VAL         [i]));
	else
	(*(component_Two_Level_Branch_Predictor_2-> in_BRANCH_COMPLETE_VAL         [i])) (*(    in_BRANCH_COMPLETE_VAL                     [i]));
	(*(component_Two_Level_Branch_Predictor_2->out_BRANCH_COMPLETE_ACK         [i])) (*(signal_BRANCH_COMPLETE_PREDICTOR_2_ACK         [i]));
	(*(component_Two_Level_Branch_Predictor_2-> in_BRANCH_COMPLETE_ADDRESS     [i])) (*(    in_BRANCH_COMPLETE_ADDRESS                 [i]));
	if (_param._predictor_2_have_bht)						       					
	(*(component_Two_Level_Branch_Predictor_2-> in_BRANCH_COMPLETE_BHT_HISTORY [i])) (*(signal_BRANCH_COMPLETE_PREDICTOR_2_BHT_HISTORY [i]));
	if (_param._predictor_2_have_pht)						       					
	(*(component_Two_Level_Branch_Predictor_2-> in_BRANCH_COMPLETE_PHT_HISTORY [i])) (*(signal_BRANCH_COMPLETE_PREDICTOR_2_PHT_HISTORY [i]));
	if (_param._have_meta_predictor)
	(*(component_Two_Level_Branch_Predictor_2-> in_BRANCH_COMPLETE_DIRECTION   [i])) (*(signal_BRANCH_COMPLETE_PREDICTOR_2_DIRECTION   [i]));
	else
	(*(component_Two_Level_Branch_Predictor_2-> in_BRANCH_COMPLETE_DIRECTION   [i])) (*(    in_BRANCH_COMPLETE_DIRECTION               [i]));	 
      }

    if (_param._have_meta_predictor)
      {
    // =====[component_Two_Level_Branch_Predictor_1 ]====================    

    name_component = _name+"_Two_Level_Branch_Predictor_1";
    
    log_printf(INFO,Meta_Predictor,"allocation","Allocation : %s",name_component.c_str());
    
    component_Two_Level_Branch_Predictor_1 = new morpheo::behavioural::stage_1_ifetch::predictor::meta_predictor::two_level_branch_predictor ::Two_Level_Branch_Predictor (name_component.c_str()               ,
#ifdef STATISTICS	
																					   _param_statistics                    ,
#endif
																					   *(_param._param_two_level_branch_predictor_1));
      
    // Instantiation
    (*(component_Two_Level_Branch_Predictor_1->in_CLOCK))        (*(in_CLOCK));
    
    for (uint32_t i=0; i<_param._nb_prediction; i++)
      {
	(*(component_Two_Level_Branch_Predictor_1-> in_PREDICT_VAL                 [i])) (*(    in_PREDICT_VAL                             [i]));
	(*(component_Two_Level_Branch_Predictor_1->out_PREDICT_ACK                 [i])) (*(signal_PREDICT_PREDICTOR_1_ACK                 [i]));
	(*(component_Two_Level_Branch_Predictor_1-> in_PREDICT_ADDRESS             [i])) (*(    in_PREDICT_ADDRESS                         [i]));
	if (_param._predictor_1_have_bht)						       				       
	(*(component_Two_Level_Branch_Predictor_1->out_PREDICT_BHT_HISTORY         [i])) (*(signal_PREDICT_PREDICTOR_1_BHT_HISTORY         [i]));
	if (_param._predictor_1_have_pht)
	(*(component_Two_Level_Branch_Predictor_1->out_PREDICT_PHT_HISTORY         [i])) (*(signal_PREDICT_PREDICTOR_1_PHT_HISTORY         [i]));
      }
    
    for (uint32_t i=0; i<_param._nb_branch_complete; i++)
      {
	(*(component_Two_Level_Branch_Predictor_1-> in_BRANCH_COMPLETE_VAL         [i])) (*(    in_BRANCH_COMPLETE_VAL                     [i]));
	(*(component_Two_Level_Branch_Predictor_1->out_BRANCH_COMPLETE_ACK         [i])) (*(signal_BRANCH_COMPLETE_PREDICTOR_1_ACK         [i]));
	(*(component_Two_Level_Branch_Predictor_1-> in_BRANCH_COMPLETE_ADDRESS     [i])) (*(    in_BRANCH_COMPLETE_ADDRESS                 [i]));
	if (_param._predictor_1_have_bht)						       					
	(*(component_Two_Level_Branch_Predictor_1-> in_BRANCH_COMPLETE_BHT_HISTORY [i])) (*(signal_BRANCH_COMPLETE_PREDICTOR_1_BHT_HISTORY [i]));
	if (_param._predictor_1_have_pht)						       					
	(*(component_Two_Level_Branch_Predictor_1-> in_BRANCH_COMPLETE_PHT_HISTORY [i])) (*(signal_BRANCH_COMPLETE_PREDICTOR_1_PHT_HISTORY [i]));
	(*(component_Two_Level_Branch_Predictor_1-> in_BRANCH_COMPLETE_DIRECTION   [i])) (*(    in_BRANCH_COMPLETE_DIRECTION               [i]));	 
      }

    // =====[component_Two_Level_Branch_Predictor_0 ]====================    

    name_component = _name+"_Two_Level_Branch_Predictor_0";
    
    log_printf(INFO,Meta_Predictor,"allocation","Allocation : %s",name_component.c_str());
    
    component_Two_Level_Branch_Predictor_0 = new morpheo::behavioural::stage_1_ifetch::predictor::meta_predictor::two_level_branch_predictor ::Two_Level_Branch_Predictor (name_component.c_str()               ,
#ifdef STATISTICS	
																					   _param_statistics                    ,
#endif
																					   *(_param._param_two_level_branch_predictor_0));
      
    // Instantiation
    (*(component_Two_Level_Branch_Predictor_0->in_CLOCK))        (*(in_CLOCK));
    
    for (uint32_t i=0; i<_param._nb_prediction; i++)
      {
	(*(component_Two_Level_Branch_Predictor_0-> in_PREDICT_VAL                 [i])) (*(    in_PREDICT_VAL                             [i]));
	(*(component_Two_Level_Branch_Predictor_0->out_PREDICT_ACK                 [i])) (*(signal_PREDICT_PREDICTOR_0_ACK                 [i]));
	(*(component_Two_Level_Branch_Predictor_0-> in_PREDICT_ADDRESS             [i])) (*(    in_PREDICT_ADDRESS                         [i]));
	if (_param._predictor_0_have_bht)						       				       
	(*(component_Two_Level_Branch_Predictor_0->out_PREDICT_BHT_HISTORY         [i])) (*(signal_PREDICT_PREDICTOR_0_BHT_HISTORY         [i]));
	if (_param._predictor_0_have_pht)
	(*(component_Two_Level_Branch_Predictor_0->out_PREDICT_PHT_HISTORY         [i])) (*(signal_PREDICT_PREDICTOR_0_PHT_HISTORY         [i]));
      }
    
    for (uint32_t i=0; i<_param._nb_branch_complete; i++)
      {
	(*(component_Two_Level_Branch_Predictor_0-> in_BRANCH_COMPLETE_VAL         [i])) (*(    in_BRANCH_COMPLETE_VAL                     [i]));
	(*(component_Two_Level_Branch_Predictor_0->out_BRANCH_COMPLETE_ACK         [i])) (*(signal_BRANCH_COMPLETE_PREDICTOR_0_ACK         [i]));
	(*(component_Two_Level_Branch_Predictor_0-> in_BRANCH_COMPLETE_ADDRESS     [i])) (*(    in_BRANCH_COMPLETE_ADDRESS                 [i]));
	if (_param._predictor_0_have_bht)						       					
	(*(component_Two_Level_Branch_Predictor_0-> in_BRANCH_COMPLETE_BHT_HISTORY [i])) (*(signal_BRANCH_COMPLETE_PREDICTOR_0_BHT_HISTORY [i]));
	if (_param._predictor_0_have_pht)						       					
	(*(component_Two_Level_Branch_Predictor_0-> in_BRANCH_COMPLETE_PHT_HISTORY [i])) (*(signal_BRANCH_COMPLETE_PREDICTOR_0_PHT_HISTORY [i]));
	(*(component_Two_Level_Branch_Predictor_0-> in_BRANCH_COMPLETE_DIRECTION   [i])) (*(    in_BRANCH_COMPLETE_DIRECTION               [i]));	 
      }
      }

    log_printf(FUNC,Meta_Predictor,"allocation","End");
  };

}; // end namespace meta_predictor
}; // end namespace predictor
}; // end namespace stage_1_ifetch
}; // end namespace behavioural
}; // end namespace morpheo              
#endif
