#ifdef SYSTEMC
/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Stage_1_Ifetch/Predictor/Meta_Predictor/include/Meta_Predictor.h"

namespace morpheo                    {
namespace behavioural {
namespace stage_1_ifetch {
namespace predictor {
namespace meta_predictor {

  void Meta_Predictor::deallocation (void)
  {
    log_printf(FUNC,Meta_Predictor,"deallocation","Begin");

    delete in_CLOCK;

    for (uint32_t i=0; i<_param._nb_prediction; i++)
      {
	delete  in_PREDICT_VAL                 [i];
	delete out_PREDICT_ACK                 [i];
	delete  in_PREDICT_ADDRESS             [i];
	delete out_PREDICT_HISTORY             [i];
	delete out_PREDICT_DIRECTION           [i];
      }

    delete  in_PREDICT_VAL        ;
    delete out_PREDICT_ACK        ;
    delete  in_PREDICT_ADDRESS    ;
    delete out_PREDICT_HISTORY    ;
    delete out_PREDICT_DIRECTION  ;

    for (uint32_t i=0; i<_param._nb_branch_complete; i++)
      {
	delete  in_BRANCH_COMPLETE_VAL         [i];
	delete out_BRANCH_COMPLETE_ACK         [i];
	delete  in_BRANCH_COMPLETE_ADDRESS     [i];
	delete  in_BRANCH_COMPLETE_HISTORY     [i];
	delete  in_BRANCH_COMPLETE_DIRECTION   [i];
      }

    delete  in_BRANCH_COMPLETE_VAL        ;
    delete out_BRANCH_COMPLETE_ACK        ;
    delete  in_BRANCH_COMPLETE_ADDRESS    ;
    delete  in_BRANCH_COMPLETE_HISTORY    ;
    delete  in_BRANCH_COMPLETE_DIRECTION  ;

    // ~~~~~[Signal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    for (uint32_t i=0; i<_param._nb_prediction; i++)
      {
	if (_param._have_meta_predictor)
	  {									      					      
	delete signal_PREDICT_PREDICTOR_0_ACK         [i];
	delete signal_PREDICT_PREDICTOR_1_ACK         [i];
	  }
	delete signal_PREDICT_PREDICTOR_2_ACK         [i];

	if (_param._have_meta_predictor)
	  {									      					      
	if (_param._predictor_0_have_bht)
	delete signal_PREDICT_PREDICTOR_0_BHT_HISTORY [i];
	if (_param._predictor_0_have_pht)
	delete signal_PREDICT_PREDICTOR_0_PHT_HISTORY [i];
	if (_param._predictor_1_have_bht)
	delete signal_PREDICT_PREDICTOR_1_BHT_HISTORY [i];
	if (_param._predictor_1_have_pht)
	delete signal_PREDICT_PREDICTOR_1_PHT_HISTORY [i];
	  }
	if (_param._predictor_2_have_bht)
	delete signal_PREDICT_PREDICTOR_2_BHT_HISTORY [i];
	if (_param._predictor_2_have_pht)
	delete signal_PREDICT_PREDICTOR_2_PHT_HISTORY [i];
      }

    if (_param._have_meta_predictor)
      {
    delete signal_PREDICT_PREDICTOR_0_ACK         ;
    delete signal_PREDICT_PREDICTOR_1_ACK         ;
      }
    delete signal_PREDICT_PREDICTOR_2_ACK         ;

    if (_param._have_meta_predictor)
      {									      					      
    if (_param._predictor_0_have_bht)
    delete signal_PREDICT_PREDICTOR_0_BHT_HISTORY;
    if (_param._predictor_0_have_pht)
    delete signal_PREDICT_PREDICTOR_0_PHT_HISTORY;
    if (_param._predictor_0_have_bht)
    delete signal_PREDICT_PREDICTOR_1_BHT_HISTORY;
    if (_param._predictor_1_have_pht)
    delete signal_PREDICT_PREDICTOR_1_PHT_HISTORY;
      }						  
    if (_param._predictor_2_have_bht)
    delete signal_PREDICT_PREDICTOR_2_BHT_HISTORY;
    if (_param._predictor_2_have_pht)
    delete signal_PREDICT_PREDICTOR_2_PHT_HISTORY;

    for (uint32_t i=0; i<_param._nb_branch_complete; i++)
      {
	if (_param._have_meta_predictor)
	  {									      					      
	delete signal_BRANCH_COMPLETE_PREDICTOR_0_ACK         [i];
	delete signal_BRANCH_COMPLETE_PREDICTOR_1_ACK         [i];
	delete signal_BRANCH_COMPLETE_PREDICTOR_2_VAL         [i];
	delete signal_BRANCH_COMPLETE_PREDICTOR_2_DIRECTION   [i];
	  }
	delete signal_BRANCH_COMPLETE_PREDICTOR_2_ACK         [i];

	if (_param._have_meta_predictor)
	  {									      					      
	if (_param._predictor_0_have_bht)
	delete signal_BRANCH_COMPLETE_PREDICTOR_0_BHT_HISTORY [i];
	if (_param._predictor_0_have_pht)
	delete signal_BRANCH_COMPLETE_PREDICTOR_0_PHT_HISTORY [i];
	if (_param._predictor_1_have_bht)
	delete signal_BRANCH_COMPLETE_PREDICTOR_1_BHT_HISTORY [i];
	if (_param._predictor_1_have_pht)
	delete signal_BRANCH_COMPLETE_PREDICTOR_1_PHT_HISTORY [i];
	  }
	if (_param._predictor_2_have_bht)
	delete signal_BRANCH_COMPLETE_PREDICTOR_2_BHT_HISTORY [i];
	if (_param._predictor_2_have_pht)
	delete signal_BRANCH_COMPLETE_PREDICTOR_2_PHT_HISTORY [i];
      }

    if (_param._have_meta_predictor)
      {
    delete signal_BRANCH_COMPLETE_PREDICTOR_0_ACK         ;
    delete signal_BRANCH_COMPLETE_PREDICTOR_1_ACK         ;
    delete signal_BRANCH_COMPLETE_PREDICTOR_2_VAL         ;
    delete signal_BRANCH_COMPLETE_PREDICTOR_2_DIRECTION   ;
      }
    delete signal_BRANCH_COMPLETE_PREDICTOR_2_ACK         ;

    if (_param._have_meta_predictor)
      {									      					      
    if (_param._predictor_0_have_bht)
    delete signal_BRANCH_COMPLETE_PREDICTOR_0_BHT_HISTORY;
    if (_param._predictor_0_have_pht)
    delete signal_BRANCH_COMPLETE_PREDICTOR_0_PHT_HISTORY;
    if (_param._predictor_0_have_bht)
    delete signal_BRANCH_COMPLETE_PREDICTOR_1_BHT_HISTORY;
    if (_param._predictor_1_have_pht)
    delete signal_BRANCH_COMPLETE_PREDICTOR_1_PHT_HISTORY;
      }						  
    if (_param._predictor_2_have_bht)
    delete signal_BRANCH_COMPLETE_PREDICTOR_2_BHT_HISTORY;
    if (_param._predictor_2_have_pht)
    delete signal_BRANCH_COMPLETE_PREDICTOR_2_PHT_HISTORY;

    // ~~~~~[Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    if (_param._have_meta_predictor)
      {
    delete component_Two_Level_Branch_Predictor_0;
    delete component_Two_Level_Branch_Predictor_1;
      }
    delete component_Two_Level_Branch_Predictor_2;
    delete component_Meta_Predictor_Glue         ;


    log_printf(FUNC,Meta_Predictor,"deallocation","End");
  };

}; // end namespace meta_predictor
}; // end namespace predictor
}; // end namespace stage_1_ifetch

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
