/*
 * $Id$
 *
 * [Description ]
 * 
 * Test
 */

#define NB_ITERATION 32

#include "Behavioural/Generic/RegisterFile/RegisterFile_Monolithic/SelfTest/include/test.h"
#include "Common/include/Test.h"

void test (string name,
	   morpheo::behavioural::generic::registerfile::registerfile_monolithic::Parameters param)
{
  cout << "<" << name << "> : Simulation SystemC" << endl;

  try 
    {
      cout << param.print(1);
      param.test();
    }
  catch (morpheo::ErrorMorpheo & error)
    {
      cout << "<" << name << "> : " <<  error.what ();
      return;
    }
  catch (...)
    {
      cerr << "<" << name << "> : This test must generate a error" << endl;
      exit (EXIT_FAILURE);
    }

  RegisterFile_Monolithic * registerfile = new RegisterFile_Monolithic (name.c_str()
#ifdef STATISTICS
									,morpheo::behavioural::Parameters_Statistics(5,1000)
#endif
									,param);
  
#ifdef SYSTEMC
  /*********************************************************************
   * Dclarations des signaux
   *********************************************************************/
  sc_clock                                 CLOCK ("clock", 1.0, 0.5);
  sc_signal<Tcontrol_t>                    NRESET;
  
  sc_signal<Tcontrol_t>                    READ_VAL      [param._nb_port_read];
  sc_signal<Tcontrol_t>                    READ_ACK      [param._nb_port_read];
  sc_signal<Taddress_t>                    READ_ADDRESS  [param._nb_port_read];
  sc_signal<Tdata_t>                       READ_DATA     [param._nb_port_read];

  sc_signal<Tcontrol_t>                    WRITE_VAL     [param._nb_port_write];
  sc_signal<Tcontrol_t>                    WRITE_ACK     [param._nb_port_write];
  sc_signal<Taddress_t>                    WRITE_ADDRESS [param._nb_port_write];
  sc_signal<Tdata_t>                       WRITE_DATA    [param._nb_port_write];

  /********************************************************
   * Instanciation
   ********************************************************/
  
  cout << "<" << name << "> Instanciation of registerfile" << endl;
  
  (*(registerfile->in_CLOCK))        (CLOCK);
  (*(registerfile->in_NRESET))       (NRESET);

  for (uint32_t i=0; i<param._nb_port_read; i++)
    {
      (*(registerfile-> in_READ_VAL      [i]))        (READ_VAL      [i]);
      (*(registerfile->out_READ_ACK      [i]))        (READ_ACK      [i]);
      (*(registerfile-> in_READ_ADDRESS  [i]))        (READ_ADDRESS  [i]);
      (*(registerfile->out_READ_DATA     [i]))        (READ_DATA     [i]);
    }

  for (uint32_t i=0; i<param._nb_port_write; i++)
    {
      (*(registerfile-> in_WRITE_VAL     [i]))        (WRITE_VAL     [i]);
      (*(registerfile->out_WRITE_ACK     [i]))        (WRITE_ACK     [i]);
      (*(registerfile-> in_WRITE_ADDRESS [i]))        (WRITE_ADDRESS [i]);
      (*(registerfile-> in_WRITE_DATA    [i]))        (WRITE_DATA    [i]);
    }
  
  cout << "<" << name << "> Start Simulation ............" << endl;
  Time * _time = new Time();

  /********************************************************
   * Simulation - Begin
   ********************************************************/

  // Initialisation

  sc_start(0);
  
  for (uint32_t i=0; i<param._nb_port_write; i++)
    WRITE_VAL [i] .write (0);

  for (uint32_t i=0; i<param._nb_port_read; i++)
    READ_VAL  [i] .write (0);

  NRESET.write(0);

  sc_start(5);

  NRESET.write(1);


  for (uint32_t nb_iteration=0; nb_iteration < NB_ITERATION; nb_iteration ++)
    {
      cout << "<" << name << "> 1) Write the RegisterFile (no read)" << endl;

      // random init
      uint32_t grain = 0;
      //uint32_t grain = static_cast<uint32_t>(time(NULL));
      
      srand(grain);

      Tdata_t tab [param._nb_word];
      
      for (uint32_t i=0; i<param._nb_word; i++)
	tab[i]= rand()%(1<<(param._size_word-1));
      
      Taddress_t address_next = 0;
      Taddress_t nb_ack = 0;
      
      while (nb_ack < param._nb_word)
	{
	  cout << "cycle : " << static_cast<uint32_t> (sc_simulation_time()) << endl;

	  for (uint32_t num_port=0; num_port < param._nb_port_write; num_port ++)
	    {
	      if ((address_next < param._nb_word) and
		  (WRITE_VAL [num_port].read() == 0))
		{
		  cout << "(" << num_port << ") [" << address_next << "] <= " << tab[address_next] << endl;
		  
		  WRITE_VAL     [num_port] .write(1);
		  WRITE_DATA    [num_port] .write(tab[address_next]);
		  WRITE_ADDRESS [num_port] .write(address_next++);
		  
		  // Address can be not a multiple of nb_port_write
		  if (address_next >= param._nb_word)
		    break;
		}
	    }
	  
	  sc_start(1);

	  // reset write_val port
	  for (uint32_t num_port=0; num_port < param._nb_port_write; num_port ++)
	    {
	      if ((WRITE_ACK [num_port].read() == 1) and
		  (WRITE_VAL [num_port].read() == 1))
		{
		  WRITE_VAL  [num_port] .write(0);
		  nb_ack ++;
		}
	    }

	  sc_start(0);
	}
      
      address_next = 0;
      nb_ack       = 0;

      cout << "<" << name << "> 2) Read the RegisterFile (no write)" << endl;
      
      Tdata_t read_address [param._nb_port_read];

      while (nb_ack < param._nb_word)
	{
	  cout << "cycle : " << static_cast<uint32_t> (sc_simulation_time()) << endl;
	  
	  for (uint32_t num_port=0; num_port < param._nb_port_read; num_port ++)
	    {
	      if ((address_next < param._nb_word) and
		  (READ_VAL [num_port].read() == 0))
		{
		  read_address [num_port] = address_next++;

		  READ_VAL     [num_port].write(1);
		  READ_ADDRESS [num_port].write(read_address [num_port]);

		  if (address_next >= param._nb_word)
		    break;
		}
	    }

	  sc_start(1);

	  // reset write_val port
	  for (uint32_t num_port=0; num_port < param._nb_port_read; num_port ++)
	    {
	      if ((READ_ACK [num_port].read() == 1) and
		  (READ_VAL [num_port].read() == 1))
		{
		  READ_VAL  [num_port] .write(0);

		  cout << "(" << num_port << ") [" << read_address [num_port] << "] => " << READ_DATA [num_port].read() << endl;

		  TEST(Tdata_t,READ_DATA [num_port].read(), tab[read_address [num_port]]);
		  nb_ack ++;
		}
	    }

	  sc_start(0);
	}
    }

  /********************************************************
   * Simulation - End
   ********************************************************/

  TEST_STR(bool,true,true, "End of Simulation");
  delete _time;
  cout << "<" << name << "> ............ Stop Simulation" << endl;

#endif

  delete registerfile;
}
