#ifndef TEST_H
#define TEST_H

#include <iostream>
#include <sstream>
#include <stdint.h>
#include "Common/include/ErrorMorpheo.h"
using namespace std;

//-----[ Routine de test ]---------------------------------------

static uint32_t num_test;

template <class T>
void test_ko (T exp1, T exp2, char * file, uint32_t line)
{
  string msg = ("<"+toString(num_test)+"> : Test KO\n" +
		" * Localisation\n"                    +
		"   - File : "+file+"\n"               +
		"   - Line : "+toString(line)+"\n"     +
		" * Expression is different\n"         +
		"   - exp1 : "+toString(exp1)+"\n"     +
		"   - exp2 : "+toString(exp2)+"\n");
  
  throw (ErrorMorpheo (msg));
};

void test_ko (char * file, uint32_t line)
{
  string msg = ("<"+toString(num_test)+"> : Test KO\n" +
		" * Localisation\n"                    +
		"   - File : "+file+"\n"               +
		"   - Line : "+toString(line)+"\n");
  
  throw (ErrorMorpheo (msg));
};

void test_ok ()
{
  cout << "{" << num_test << "} : Test OK" << endl;

  num_test ++;
};

template <class T>
void test(T exp1, T exp2, char * file, uint32_t line)
{
  if (exp1 != exp2)
    test_ko <T> (exp1,exp2,file,line);
  else
    test_ok     ();
};

#define TEST(type,exp1,exp2)            do {test<type> (exp1,exp2,__FILE__,__LINE__);} while(0)
#define TEST_STR(type,exp1,exp2,str...) do {fprintf(stdout,str); fprintf(stdout,"\n"); test<type> (exp1,exp2,__FILE__,__LINE__);} while(0)
#define TEST_OK(str...)                 do {fprintf(stdout,str); fprintf(stdout,"\n"); test_ok();} while(0)
#define TEST_KO(str...)                 do {fprintf(stdout,str); fprintf(stdout,"\n"); test_ko(__FILE__,__LINE__);} while(0)


#endif
