#ifdef VHDL
/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Generic/RegisterFile/RegisterFile_Multi_Banked/include/RegisterFile_Multi_Banked.h"

namespace morpheo {
namespace behavioural {
namespace generic {
namespace registerfile {
namespace registerfile_multi_banked {


  void RegisterFile_Multi_Banked::vhdl_declaration (Vhdl * & vhdl)
  {
    log_printf(FUNC,RegisterFile_Multi_Banked,"vhdl_declaration","Begin");

    vhdl->set_type   ("Tregfile", "array (" + toString(_param._nb_word_by_bank-1) + " downto 0) of " + std_logic(_param._size_word));

    vhdl->set_type   ("Tbank"   , "array (" + toString(_param._nb_bank)           + " downto 0) of Tregfile");

    vhdl->set_signal ("reg_DATA", "Tbank");

    for (uint32_t i=0; i<_param._nb_bank; i++)
      {
	for (uint32_t j=0; j<_param._nb_port_read_by_bank; j ++)
	  {
	    vhdl->set_signal ("internal_READ_"+toString(i)+"_"+toString(j)+"_VAL"  ,1);
	    vhdl->set_signal ("internal_READ_"+toString(i)+"_"+toString(j)+"_PORT" ,static_cast<uint32_t>(ceil(log2(_param._nb_port_read))));
	  }
	for (uint32_t j=0; j<_param._nb_port_write_by_bank; j ++)
	  {
	    vhdl->set_signal ("internal_WRITE_"+toString(i)+"_"+toString(j)+"_VAL" ,1);
	    vhdl->set_signal ("internal_WRITE_"+toString(i)+"_"+toString(j)+"_PORT",static_cast<uint32_t>(ceil(log2(_param._nb_port_write))));
	  }
      }

    log_printf(FUNC,RegisterFile_Multi_Banked,"vhdl_declaration","End");
  };

}; // end namespace registerfile_multi_banked
}; // end namespace registerfile
}; // end namespace generic

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
