/*
 * $Id$
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Read_unit/Read_unit/Reservation_station/include/Parameters.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace multi_read_unit {
namespace read_unit {
namespace reservation_station {


#undef  FUNCTION
#define FUNCTION "Reservation_station::Parameters"
  Parameters::Parameters (uint32_t size_queue         ,
			  uint32_t nb_context         ,
			  uint32_t nb_packet          ,
			  uint32_t size_general_data  ,
			  uint32_t size_special_data  ,
			  uint32_t nb_general_register,
			  uint32_t nb_special_register,
			  uint32_t nb_operation       ,
			  uint32_t nb_type            ,
			  uint32_t nb_gpr_write       ,
			  uint32_t nb_spr_write       ,
			  uint32_t nb_bypass_write    ,
			  uint32_t nb_bypass_memory   ):
    _size_queue            (size_queue           ),
    _nb_context            (nb_context           ),
    _nb_packet             (nb_packet            ),
    _size_general_data     (size_general_data    ),
    _size_special_data     (size_special_data    ),
    _nb_general_register   (nb_general_register  ),
    _nb_special_register   (nb_special_register  ),
    _nb_operation          (nb_operation         ),
    _nb_type               (nb_type              ),
    _nb_gpr_write          (nb_gpr_write         ),
    _nb_spr_write          (nb_spr_write         ),
    _nb_bypass_write       (nb_bypass_write      ),
    _nb_bypass_memory      (nb_bypass_memory     ),

    _size_context_id       (static_cast<uint32_t>(log2(_nb_context         ))),
    _size_packet_id        (static_cast<uint32_t>(log2(_nb_packet          ))),
    _size_general_register (static_cast<uint32_t>(log2(_nb_general_register))),
    _size_special_register (static_cast<uint32_t>(log2(_nb_special_register))),
    _size_operation        (static_cast<uint32_t>(log2(_nb_operation       ))),
    _size_type             (static_cast<uint32_t>(log2(_nb_type            )))
  {
    log_printf(FUNC,Reservation_station,FUNCTION,"Begin");
    test();
    log_printf(FUNC,Reservation_station,FUNCTION,"End");
  };
  
#undef  FUNCTION
#define FUNCTION "Reservation_station::Parameters (copy)"
  Parameters::Parameters (Parameters & param):
    _size_queue            (param._size_queue            ),
    _nb_context            (param._nb_context            ),
    _nb_packet             (param._nb_packet             ),
    _size_general_data     (param._size_general_data     ),
    _size_special_data     (param._size_special_data     ),
    _nb_general_register   (param._nb_general_register   ),
    _nb_special_register   (param._nb_special_register   ),
    _nb_operation          (param._nb_operation          ),
    _nb_type               (param._nb_type               ),
    _nb_gpr_write          (param._nb_gpr_write          ),
    _nb_spr_write          (param._nb_spr_write          ),
    _nb_bypass_write       (param._nb_bypass_write       ),
    _nb_bypass_memory      (param._nb_bypass_memory      ),

    _size_context_id       (param._size_context_id       ),
    _size_packet_id        (param._size_packet_id        ),
    _size_general_register (param._size_general_register ),
    _size_special_register (param._size_special_register ),
    _size_operation        (param._size_operation        ),
    _size_type             (param._size_type             )
  {
    log_printf(FUNC,Reservation_station,FUNCTION,"Begin");
    test();
    log_printf(FUNC,Reservation_station,FUNCTION,"End");
  };

#undef  FUNCTION
#define FUNCTION "Reservation_station::~Parameters"
  Parameters::~Parameters () 
  {
    log_printf(FUNC,Reservation_station,FUNCTION,"Begin");
    log_printf(FUNC,Reservation_station,FUNCTION,"End");
  };

}; // end namespace reservation_station
}; // end namespace read_unit
}; // end namespace multi_read_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
